<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get categories
$categories = ovaev_get_meta_data( 'categories', $args );
if ( ovaev_array_exists( $categories ) ): ?>
    <div class="tagcloud">
        <?php foreach ( $categories as $cate ):
            $cat_name = $cate->cat_name;
            $cat_link = get_term_link( $cate->term_id );
            if ( is_wp_error( $cat_link ) ) continue;
        ?>
            <a class="tag-cloud-link" href="<?php echo esc_url( $cat_link ); ?>">
                <?php echo esc_html( $cat_name ); ?>
            </a>
         <?php endforeach; ?>
    </div>
<?php endif; ?>