<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get date format
$date_format = get_option( 'date_format' );

// Get time format
$time_format = OVAEV_Settings::archive_event_format_time();

// Get events
$events = ovaev_get_meta_data( 'list_events', $args );

if ( $events ): ?>
    <div class="list-event">
        <?php foreach ( $events as $event ):
            // Get event id
            $event_id = $event->ID;

            // Get event title
            $title = get_the_title( $event_id );

            // Get image URL
            $url_img = get_the_post_thumbnail_url( $event_id, 'post-thumbnail' );

            // Get event link
            $link = get_the_permalink( $event_id );

            // Get start date time
            $start_datetime = get_post_meta( $event_id, 'ovaev_start_date_time', true );

            // Start date & time
            $start_date = $start_time = '';
            if ( $start_datetime ) {
                $start_date = date_i18n( $date_format, $start_datetime );

                // Start time
                if ( get_post_meta( $event_id, 'ovaev_start_time', true ) ) {
                    $start_time = date_i18n( $time_format, $start_datetime );
                }
            }

            // Get end date time
            $end_datetime = get_post_meta( $event_id, 'ovaev_end_date_time', true );

            // End date & time
            $end_date = $end_time = '';
            if ( $end_datetime ) {
                $end_date = date_i18n( $date_format, $end_datetime );

                // End time
                if ( get_post_meta( $event_id, 'ovaev_end_time', true ) ) {
                    $end_time = date_i18n( $time_format, $end_datetime );
                }
            }

            ?>

            <div class="item-event">
               <div class="ova-thumb-nail">
                   <a href="<?php echo esc_url( $link ); ?>" style="background-image:url(<?php echo esc_url( $url_img ); ?>)">
                   </a>
               </div>
               <div class="ova-content">
                    <h3 class="title">
                        <a class="second_font" href="<?php echo esc_url( $link ); ?>">
                            <?php echo wp_kses_post( $title ); ?>
                        </a>
                    </h3>
                    <?php if ( $start_date && $start_date == $end_date ): ?>
                        <span class="time">
                            <span class="date">
                                <?php if ( $end_time ) {
                                    echo sprintf( esc_html__( '%s - %s', 'ovaev' ), $start_date, $end_time );
                                } else {
                                    echo esc_html( $start_date );
                                } ?>
                            </span>
                        </span>
                    <?php else: ?>
                        <span class="time">
                            <?php if ( $start_time ): ?>
                                <span class="date">
                                    <?php echo sprintf( esc_html__( '%s @', 'ovaev' ), $start_date ); ?>
                                </span>
                                <span><?php echo esc_html( $start_time ); ?></span>
                                <?php if ( apply_filters( 'ovaev_show_more_date_text', true ) ): ?>
                                    <a href="<?php echo esc_url( $link ); ?> " class="more_date_text" data-id="<?php echo esc_attr( get_the_id() ); ?>">
                                        <span><?php esc_html_e( ', more', 'ovaev' ); ?></span>  
                                    </a>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="date">
                                    <?php echo esc_html( $start_date ); ?>
                                </span>
                            <?php endif; ?>
                        </span>
                    <?php endif; ?>
               </div>
            </div>
        <?php endforeach; ?>
    </div>
    <div class="button-all-event">
        <a class="second_font" href="<?php echo esc_url( apply_filters( 'ovaev_upcomming_event_url', get_post_type_archive_link( 'event' ) ) ); ?>">
            <?php esc_html_e( 'View All Events', 'ovaev' ); ?>
            <i data-feather="chevron-right"></i>
        </a>
    </div>
<?php endif; ?>