<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get events
$events = ovaev_get_meta_data( 'events', $args );

if ( ovaev_array_exists( $events ) ): ?>
    <div class="event-feature slide-event-feature owl-carousel owl-theme">
        <?php foreach ( $events as $event ):
            // Get event id
            $event_id = $event->ID;
        ?>
            <div class="ovaev-content">
                <div class="item">
                    <?php // Show highlight date 2
                        do_action( 'ovaev_loop_highlight_date_2', $event_id );
                    ?>
                    <div class="desc">
                        <?php // Show thumbnail grid
                            do_action( 'ovaev_loop_thumbnail_grid', $event_id );
                        ?>
                        <div class="event_post">
                            <?php
                                // Show type
                                do_action( 'ovaev_loop_type', $event_id );

                                // Show title
                                do_action( 'ovaev_loop_title', $event_id );
                            ?>
                            <div class="time-event">
                                <?php
                                    // Show date
                                    do_action( 'ovaev_loop_date_event', $event_id );

                                    // Show venue
                                    do_action( 'ovaev_loop_venue', $event_id );
                                ?>
                            </div>        
                            <?php
                                // Show read more button
                                do_action( 'ovaev_loop_readmore_2', $event_id );
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>