<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get categories
$categories = ovaev_get_meta_data( 'categories', $args );

// Get count
$count = ovaev_get_meta_data( 'count', $args );

if ( ovaev_array_exists( $categories ) ): ?>
    <ul>
        <?php foreach ( $categories as $cate ): ?>
            <li>
                <a href="<?php echo esc_url( get_term_link( $cate->term_id ) ) ?>">
                    <?php echo esc_html( $cate->cat_name ) ?>
                </a>
                <?php if ( 1 == $count ) {
                    echo sprintf( esc_html__( '(%s)', 'ovaev' ), $cate->count );
                } ?>
            </li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>
