<?php if ( !defined( 'ABSPATH' ) ) exit(); 

// Get event id
$event_id = get_the_ID();

// Get tiem format
$time_format = OVAEV_Settings::archive_event_format_time();

// Get start time
$start_time = strtotime( get_post_meta( $event_id, 'ovaev_start_time', true ) );
$start_time = $start_time ? date_i18n( $time_format, $start_time ) : '';

// Get end time
$end_time = strtotime( get_post_meta( $event_id, 'ovaev_end_time', true ) );
$end_time = $end_time ? date_i18n( $time_format, $end_time ) : '';

if ( $start_time ): ?>
	<div class="wrap-time wrap-pro">
		<i class="far fa-clock"></i>
		<span class="second_font general-content">
			<?php echo esc_html( $start_time ); ?>
		</span>
		<?php if ( $end_time ): ?>
			<span class="separation"> - </span>
			<span class="second_font general-content">
				<?php echo esc_html( $end_time ); ?>
			</span>
		<?php endif; ?>
	</div>
<?php endif; ?>