<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get date format
$date_format = get_option( 'date_format' );

// Get event id
$event_id = get_the_ID();

// Get start date
$start_date = get_post_meta( $event_id, 'ovaev_start_date_time', true );
$start_date = $start_date ? date_i18n( $date_format, $start_date ) : '';

// Get end date
$end_date = get_post_meta( $event_id, 'ovaev_end_date_time', true );
$end_date = $end_date ? date_i18n( $date_format, $end_date ) : '';

if ( $start_date ): ?>
	<div class="wrap-date wrap-pro">
		<?php if ( $end_date && $start_date === $end_date ): ?>
			<i class="fas fa-calendar-alt"></i>
			<span class="second_font general-content">
				<?php echo esc_html( $start_date );?>
			</span>
		<?php else: ?>
			<i class="fas fa-calendar-alt"></i>
			<span class="second_font general-content">
				<?php echo esc_html( $start_date ); ?>
			</span>
			<?php if ( $end_date ): ?>
				<span class="second_font general-content">
					<span class="separation"> - </span>
					<?php echo esc_html( $end_date ); ?>
				</span>
			<?php endif; ?>
		<?php endif; ?>
	</div>
<?php endif;