<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get header
get_header();

// Get event id
$event_id = get_the_ID();

// Get product id
$product_id = OVAEV_Settings::ovaev_booking_via_woo();

// Get event address
$event_address = get_post_meta( $event_id, 'ovaev_map_address', true );

// Get event latitude
$event_map_lat = get_post_meta( $event_id, 'ovaev_map_lat', true );

// Get event longitude
$event_map_lng = get_post_meta( $event_id, 'ovaev_map_lng', true );

// Get event map zoom
$event_map_zoom = OVAEV_Settings::event_map_zoom();

// Get event name
$event_name = get_post_meta( $event_id, 'ovaev_organizer', true );

// Get event phone
$event_phone = get_post_meta( $event_id, 'ovaev_phone', true );

// Get event email
$event_email = get_post_meta( $event_id, 'ovaev_email', true );

// Get event website
$event_website = get_post_meta( $event_id, 'ovaev_website', true );

// Get event gallery
$event_gallery = get_post_meta( $event_id, 'ovaev_gallery_id', true );

// Get event template
$event_template = get_post_meta( $event_id, 'event_template', true ) ? get_post_meta( $event_id, 'event_template', true ) : 'global';

// Get event booking
$event_booking_via = get_post_meta( $event_id, 'event_booking_via', true );

// Get event booking link
$event_booking_links = get_post_meta( $event_id, 'ovaev_booking_links', true );

// Sidebar
$sidebar_single = isset( $_GET['show_sidebar_single'] ) ? $_GET['show_sidebar_single'] : OVAEV_Settings::ovaev_show_sidebar_single();

$active_sidebar = 'main-event';
if ( 'yes' === $sidebar_single && is_active_sidebar( 'event-sidebar' ) ) {
	$active_sidebar = 'sidebar-active';
}

// Get template
$template = OVAEV_Settings::ovaev_get_template_single();

if ( 'default' != $template ):
	if ( 'global' != $event_template ) {
		echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $event_template );
	} else {
		echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $template );
	}
else:
	if ( 'global' != $event_template ):
		echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $event_template );
	else: ?>
		<div class="single_event">
			<div class="container-event">
				<div id="<?php echo esc_attr( $active_sidebar ); ?>" class="content-event">	
					<div class="event_intro">
						<?php
							// Thumbnail
							do_action( 'oavev_single_thumbnail' );

							// Title
							do_action( 'ovaev_single_title' );
						?>
						
						<div class="wrap-event-info">
							<div class="wrap-info">
								<?php 
									/**
									 * action oavev_single_time_loc
									 * Hooked oavev_single_time_loc_date
									 * Hooked oavev_single_time_loc_time
									 * Hooked oavev_single_time_loc_location
									 */
									do_action( 'oavev_single_time_loc' );
									do_action( 'oavev_single_price' );
									do_action( 'oavev_single_type' );
								?>
							</div>
							<?php if ( 'default' != $product_id && 'woocommerce' == $event_booking_via ): ?>
								<div class="wrap-booking-links ovaev-booking-via-woo">
									<?php do_action( 'oavev_single_booking_cart' ); ?>
								</div>
							<?php else:
								if ( $event_booking_links && 'custom_link' == $event_booking_via ): ?>
									<div class="wrap-booking-links">
										<?php do_action( 'oavev_single_booking_links' ); ?>
									</div>
								<?php endif;
							endif; ?>
						</div>
						<div class="content">
							<?php if( have_posts() ) : while( have_posts() ) : the_post();
								the_content();
					 		endwhile; endif; wp_reset_postdata(); ?>
						</div>
						<?php if ( $event_address || $event_name || $event_phone || $event_email || $event_website || ovaev_array_exists( $event_gallery ) ): ?>
							<div class="tab-Location">
								<ul class="event_nav event_nav-tabs" role="tablist">
									<?php if ( $event_address ): ?>
									 	<li class="event_nav-item">
									    	<a class="event_nav-link second_font " data-href="#location" role="tab">
									    		<?php esc_html_e( 'Location', 'ovaev' ); ?>
									    	</a>
									  	</li>
									<?php endif;

									// Contact details
									if ( $event_name || $event_phone || $event_email || $event_website ): ?>
									  	<li class="event_nav-item">
									    	<a class="event_nav-link second_font" data-href="#contact" role="tab">
									    		<?php esc_html_e( 'Contact Details', 'ovaev' ); ?>
									    	</a>
									 	</li>
								 	<?php endif;

								 	// Gallery
								 	if ( ovaev_array_exists( $event_gallery ) ):  ?>
									  	<li class="event_nav-item">
									    	<a class="event_nav-link second_font" data-href="#gallery" role="tab">
									    		<?php esc_html_e( 'Gallery', 'ovaev' ); ?>
									    	</a>
									  	</li>
								  	<?php endif; ?>
								</ul>
								<!-- Tab panes -->
								<div class="tab-content">
									<?php if ( $event_address ): ?>
							  			<div role="tabpanel" 
							  				class="event_tab-pane in active" 
							  				id="location" 
							  				style="height: 500px;" 
							  				data-address="<?php echo esc_attr( $event_address ); ?>" 
							  				data-lat="<?php echo esc_attr( $event_map_lat ); ?>" 
							  				data-lng="<?php echo esc_attr( $event_map_lng ); ?>" 
							  				data-zoom="<?php echo esc_attr( $event_map_zoom ); ?>"
							  			></div>
								  	<?php endif;

								  	// Event name, phone, email, website
								  	if ( $event_name || $event_phone || $event_email || $event_website ): ?>
								  		<div role="tabpanel" class="event_tab-pane " id="contact">
								  			<div class="event_row">
												<div class="col_contact">
													<div class="contact">
														<ul class="info-contact">
															<?php if ( $event_name ) : ?>
				 												<li>
																	<span>
																		<?php esc_html_e( 'Organizer Name:', 'ovaev' ); ?>
																	</span>
																	<span class="info">
																		<?php echo esc_html( $event_name ); ?>
																	</span>
																</li>
															<?php endif;

															// Phone
															if ( $event_phone ): ?>
																<li>
																	<span>
																		<?php esc_html_e( 'Phone:', 'ovaev' ); ?>
																	</span>
																	<a href="tel:<?php echo esc_attr( $event_phone ); ?>" class="info">
																		<?php echo esc_html( $event_phone ); ?>
																	</a>
																</li>
															<?php endif; ?>
														</ul>
													</div>
												</div>
												<div class="col_contact">
													<div class="contact">
														<ul class="info-contact">
															<?php if ( $event_email ): ?>
																<li>
																	<span>
																		<?php esc_html_e( 'Email:', 'ovaev' ); ?>
																	</span>
																	<a href="mailto:<?php echo esc_attr( $event_email ); ?>" class="info">
																		<?php echo esc_html( $event_email ); ?>
																	</a>
																</li>
															<?php endif;

															// Website
															if ( $event_website ): ?>
																<li>
																	<span>
																		<?php esc_html_e( 'Website:', 'ovaev' ); ?>
																	</span>
																	<a href="<?php echo esc_url( $event_website ); ?>" class="info">
																		<?php echo esc_html( $event_website ); ?>
																	</a>
																</li>
															<?php endif; ?>
														</ul>
													</div>
												</div>
								  			</div>
								  		</div>
							  		<?php endif;

							  		// Gallery
							  		if ( ovaev_array_exists( $event_gallery ) ): ?>
							 		 	<div role="tabpanel" class="event_tab-pane " id="gallery">
							 		 		<div class="event_row">
							 		 			<?php foreach ( $event_gallery as $items ):
							 		 				$img_url = wp_get_attachment_image_url( $items, 'large' );
							 		 			?>
							 		 				<div class="event_col-6">
														<div class="gallery-items">
															<a href="<?php echo esc_url( $img_url ); ?>" data-gal="prettyPhoto[gal]">
																<img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo get_the_title(); ?>" />
															</a> 
														</div>
													</div>
							 		 			<?php endforeach; ?>
							 		 		</div>
							 		 	</div>
					 		 		<?php endif; ?>
								</div>
							</div>
						<?php endif; ?>
						<div class="event_tags_share">
							<!--  -->
							<?php
								// Tags
								do_action( 'oavev_single_tags' );

								// Share
								do_action( 'oavev_single_share' );
							?>
						</div>
						<?php
							// Navigation
							do_action( 'oavev_single_nav' );

							// Related
							do_action( 'oavev_single_related' );

							// Comment
				        	if ( comments_open( $event_id ) ) {
					        	comments_template();
					        }
				        ?>
					</div>
				</div>
				<?php if ( 'yes' === $sidebar_single ) {
					ovaev_get_template( 'sidebar-event.php' );
				} ?>
			</div>
		</div>
	<?php endif;
endif;

// Get footer
get_footer();