<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args );

// Get class
$class = ovaev_get_meta_data( 'class', $args );

// Get icon
$icon = ovaev_get_meta_data( 'icon', $args );

// Get time format
$time_format = OVAEV_Settings::archive_event_format_time();

// Get start time
$start_time = strtotime( get_post_meta( $event_id, 'ovaev_start_time', true ) );
$start_time = $start_time ? date_i18n( $time_format, $start_time ) : '';

// Get end time
$end_time = strtotime( get_post_meta( $event_id, 'ovaev_end_time', true ) );
$end_time = $end_time ? date_i18n( $time_format, $end_time ) : '';

if ( $start_time && $end_time ): ?>
	<div class="ovaev-shortcode-time <?php echo esc_attr( $class ); ?>">
		<i class="<?php echo esc_attr( $icon ); ?>"></i>
		<span class="second_font"><?php echo esc_html( $start_time ); ?></span>
		<span class="second_font"><?php echo esc_html_e( ' - ', 'ovaev' ); ?></span>
		<span class="second_font"><?php echo esc_html( $end_time ); ?></span>
	</div>
<?php endif; ?>