<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args );

// Get class
$class = ovaev_get_meta_data( 'class', $args );

// Get event address
$map_address = get_post_meta( $event_id, 'ovaev_map_address', true );

// Get event latitude
$map_lat = get_post_meta( $event_id, 'ovaev_map_lat', true );

// Get event longitude
$map_lng = get_post_meta( $event_id, 'ovaev_map_lng', true );

// Get map zoom
$map_zoom = OVAEV_Settings::event_map_zoom();

// Get organizer
$name = get_post_meta( $event_id, 'ovaev_organizer', true );

// Get phone
$phone = get_post_meta( $event_id, 'ovaev_phone', true );

// Get email
$email = get_post_meta( $event_id, 'ovaev_email', true );

// Get website
$website = get_post_meta( $event_id, 'ovaev_website', true );

// Get gallery
$gallery = get_post_meta( $event_id, 'ovaev_gallery_id', true );

if ( $map_address || $name || $phone || $email || $website || ovaev_array_exists( $gallery ) ): ?>
	<div class="single_event single-event ovaev-shortcode-tabs <?php echo esc_attr( $class ); ?>">
		<div class="content-event">
			<div class="tab-Location">
				<ul class="event_nav event_nav-tabs" role="tablist">
					<?php if ( $map_address ): ?>
					 	<li class="event_nav-item">
					    	<a class="event_nav-link second_font" data-href="#location" role="tab">
					    		<?php esc_html_e( 'Location', 'ovaev' ); ?>
					    	</a>
					  	</li>
					 <?php endif;

					 // Name, phone, email, website
					 if ( $name || $phone || $email || $website ): ?>
					  	<li class="event_nav-item">
					    	<a class="event_nav-link second_font" data-href="#contact" role="tab">
					    		<?php esc_html_e( 'Contact Details', 'ovaev' ); ?>
					    	</a>
					 	</li>
				 	<?php endif;

				 	// Gallery
				 	if ( ovaev_array_exists( $gallery ) ): ?>
					  	<li class="event_nav-item">
					    	<a class="event_nav-link second_font" data-href="#gallery" role="tab">
					    		<?php esc_html_e( 'Gallery', 'ovaev' ); ?>
					    	</a>
					  	</li>
				  	<?php endif; ?>
				</ul>

				<!-- Tab panes -->
				<div class="tab-content">
					<?php if ( $map_address ): ?>
			  			<div
			  				role="tabpanel"
			  				class="event_tab-pane in active"
			  				id="location"
			  				style="height: 500px;"
			  				data-address="<?php echo esc_attr( $map_address ); ?>"
			  				data-lat="<?php echo esc_attr( $map_lat ); ?>"
			  				data-lng="<?php echo esc_attr( $map_lng ); ?>"
			  				data-zoom="<?php echo esc_attr( $map_zoom ); ?>">
			  			</div>
				  	<?php endif;

				  	// Name, phone, email, website
				  	if ( $name || $phone || $email || $website ): ?>
				  		<div role="tabpanel" id="contact" class="event_tab-pane">
				  			<div class="event_row">
								<div class="col_contact">
									<div class="contact">
										<ul class="info-contact">
											<?php if ( $name ): ?>
												<li>
													<span>
														<?php esc_html_e( 'Organizer Name:', 'ovaev' ); ?>
													</span>
													<span class="info">
														<?php echo esc_html( $name ); ?>
													</span>
												</li>
											<?php endif;

											// Phone
											if ( $phone ): ?>
												<li>
													<span>
														<?php esc_html_e( 'Phone:', 'ovaev' ); ?>
													</span>
													<a href="tel:<?php echo esc_attr( $phone ); ?>" class="info">
														<?php echo esc_html( $phone ); ?>
													</a>
												</li>
											<?php endif; ?>
										</ul>
									</div>
								</div>
								<div class="col_contact">
									<div class="contact">
										<ul class="info-contact">
											<?php if ( $email ): ?>
												<li>
													<span>
														<?php esc_html_e( 'Email:', 'ovaev' ); ?>
													</span>
													<a href="mailto:<?php echo esc_attr( $email ); ?>" class="info">
														<?php echo esc_html( $email ); ?>
													</a>
												</li>
											<?php endif;

											// Website
											if ( $website ): ?>
												<li>
													<span>
														<?php esc_html_e( 'Website:', 'ovaev' ); ?>
													</span>
													<a href="<?php echo esc_url( $website ); ?>" class="info">
														<?php echo esc_html( $website ); ?>
													</a>
												</li>
											<?php endif; ?>
										</ul>
									</div>
								</div>
				  			</div>
				  		</div>
			  		<?php endif;

			  		// Gallery
			  		if ( ovaev_array_exists( $gallery ) ): ?>
			 		 	<div role="tabpanel" class="event_tab-pane " id="gallery">
			 		 		<div class="event_row">
			 		 			<?php foreach ( $gallery as $attachment_id ):
			 		 				$img_url = wp_get_attachment_image_url( $attachment_id, 'large' );
			 		 			?>
			 		 				<div class="event_col-6">
										<div class="gallery-items">
											<a href="<?php echo esc_url( $img_url ); ?>" data-gal="prettyPhoto[gal]">
												<img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo esc_attr( get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ) ); ?>" />
											</a> 
										</div>
									</div>
			 		 			<?php endforeach; ?>
			 		 		</div>
			 		 	</div>
	 		 		<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>