<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args );

// Get class
$class = ovaev_get_meta_data( 'class', $args );

// Get current event post
global $post;
$post = get_post( $event_id );

// Get prev post
$prev_post = get_previous_post();

// Get next post
$next_post = get_next_post();

if ( is_object( $prev_post ) || is_object( $next_post ) ): ?>
	<div class="single_event ovaev-shortcode-navigation <?php echo esc_attr( $class ); ?>">
		<div class="content-event">
			<div class="ova-next-pre-post">	
				<?php if ( is_object( $prev_post ) ): ?>
					<a class="pre" href="<?php echo esc_attr( get_permalink( $prev_post->ID ) ); ?>">
						<span class="num-1">
							<span class="icon"><i class="arrow_carrot-left"></i></span>
						</span>
						<span class="num-2">
							<span class="second_font title">
								<?php echo esc_html( get_the_title( $prev_post->ID ) ); ?>
							</span>
						</span>
					</a>
				<?php endif; ?>
				<a class="ova-slash" href="<?php echo esc_url( get_post_type_archive_link( 'event' ) ); ?>">
					<?php if ( is_object( $prev_post ) && is_object( $next_post ) ): ?>
						<span></span>
						<span></span>
						<span></span>
					<?php endif; ?>
				</a>
				<?php if ( is_object( $next_post ) ): ?>
					<a class="next" href="<?php echo esc_attr( get_permalink( $next_post->ID ) ); ?>">
						<span class="num-1">
							<span class="icon" ><i class="arrow_carrot-right"></i></span>
						</span>
						<span class="num-2">
							<span class="second_font title">
								<?php echo esc_html( get_the_title( $next_post->ID ) ); ?>
							</span>
						</span>
					</a>
				<?php endif; ?>
			</div>
		</div>
	</div>
<?php endif; ?>