<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get language
$language = OVAEV_Settings::archive_format_date_lang();

// Get date format
$date_format = OVAEV_Settings::archive_event_format_date();

// Get time format
$time_format = OVAEV_Settings::archive_event_format_time();

// Get first day
$first_day = apply_filters( 'ovaev_calendar_first_day' , get_option( 'start_of_week' ) );

// Get events
$events = ovaev_get_meta_data( 'events', $args );

// Total pages
$total_pages = 1;

// Current page
$current_page = 1;

// Get settings
$settings = ovaev_get_meta_data( 'settings', $args );
if ( ovaev_get_meta_data( 'pagination', $settings ) ) {
	$total_pages = $events->max_num_pages;
}

// Get template
$template = ovaev_get_meta_data( 'template', $settings, 1 );

// Get column
$column = ovaev_get_meta_data( 'column', $settings );

// Get time
$time = ovaev_get_meta_data( 'time', $settings );

// Include category
$incl = ovaev_get_meta_data( 'incl_category', $settings ) ? explode( ',', $settings['incl_category'] ) : [];

// Exclude category
$excl = ovaev_get_meta_data( 'excl_category', $settings ) ? explode( ',', $settings['excl_category'] ) : [];

// Get categories
$categories = ovaev_get_event_categories( $events, $incl, $excl );

?>

<div class="ovaev-filter">
	<!-- Search Form -->
	<div class="ovaev-filter-form">
		<div class="ovaev-date-fields">
			<input
				type="text"
				id="ovaev-start-date"
				class="ovaev-start-date-filter"
				name="ovaev_start_date"
				placeholder="<?php echo esc_attr__( 'Start date', 'ovaev' ); ?>"
				data-language="<?php echo esc_attr( $language ); ?>"
				data-format="<?php echo esc_attr( $date_format ); ?>"
				data-first-day="<?php echo esc_attr( $first_day ); ?>"
				autocomplete="off"
			/>
			<input
				type="text"
				id="ovaev-end-date"
				class="ovaev-start-date-filter"
				name="ovaev_end_date"
				placeholder="<?php echo esc_attr__( 'End date', 'ovaev' ); ?>"
				data-language="<?php echo esc_attr( $language ); ?>"
				data-format="<?php echo esc_attr( $date_format ); ?>"
				data-first-day="<?php echo esc_attr( $first_day ); ?>"
				autocomplete="off"
			/>
		</div>
		<div class="ovaev-keyword-field">
			<input
				type="text"
				class="ovaev-keyword"
				name="ovaev_keyword"
				placeholder="<?php echo esc_attr__( 'Search by keyword(optional)', 'ovaev' ); ?>"
				autocomplete="off"
			/>
		</div>
		<div class="ovaev-filter-time">
			<label class="ovaev-btn-checkbox">
				<span class="checkmark <?php echo 'today' === $time ? 'active' : ''; ?>" data-time="today">
					<?php esc_html_e( 'Today', 'ovaev' ); ?>
				</span>
 			</label>
			<label class="ovaev-btn-checkbox">
				<span class="checkmark <?php echo 'week' === $time ? 'active' : ''; ?>" data-time="week">
					<?php esc_html_e( 'Week', 'ovaev' ); ?>
				</span>
 			</label>
			<label class="ovaev-btn-checkbox">
				<span class="checkmark <?php echo 'weekend' === $time ? 'active' : ''; ?>" data-time="weekend">
					<?php esc_html_e( 'Weekend', 'ovaev' ); ?>
				</span>
 			</label>
 			<label class="ovaev-btn-checkbox">
				<span class="checkmark <?php echo 'past' === $time ? 'active' : ''; ?>" data-time="past">
					<?php esc_html_e( 'Past', 'ovaev' ); ?>
				</span>
 			</label>
 			<label class="ovaev-btn-checkbox">
				<span class="checkmark <?php echo 'upcoming' === $time ? 'active' : ''; ?>" data-time="upcoming">
					<?php esc_html_e( 'Upcoming', 'ovaev' ); ?>
				</span>
 			</label>
 			<input type="hidden" name="ovaev_time" value="<?php echo esc_attr( $time ); ?>" />
		</div>
		<div class="ovaev-btn-search">
			<button class="ovaev-btn-submit"><?php esc_html_e( 'Search', 'ovaev' ); ?></button>
		</div>
	</div>
	
	<!-- Event Categories -->
	<?php if ( ovaev_array_exists( $categories ) ): ?>
	<div class="ovaev-filter-categories">
		<h3 class="title">
			<?php esc_html_e( 'EVENTS', 'ovaev' ); ?>
		</h3>
		<div class="category-wrapper">
			<ul class="event-categories">
				<?php foreach ( $categories as $cat ):
					// Icon class
					$icon_class = ovaev_get_meta_data( 'icon_class', $cat );

					// Category id
					$cat_id = ovaev_get_meta_data( 'term_id', $cat );

					// Count
					$count = ovaev_get_meta_data( 'count', $cat );

					// Category name
					$cat_name = ovaev_get_meta_data( 'name', $cat );
				?>
					<li class="item-cat">
						<?php if ( $icon_class ): ?>
							<i class="<?php echo esc_attr( $icon_class ); ?>" aria-hidden="true"></i>
						<?php endif; ?>
						<a href="javascript:void(0)" class="ovaev-term" data-term-id="<?php echo esc_attr( $cat_id ); ?>" data-count="<?php echo esc_attr( $count ); ?>"
						>
							<?php echo esc_html( $cat_name ); ?>
							<span class="count">
								<?php echo sprintf( esc_html__( '(%s)', 'ovaev' ), $count ); ?>
							</span>	
						</a>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	</div>
	<?php endif; ?>
	<div class="ovaev-filter-container">
		<div class="ovaev-filter-content">
			<div class="archive_event ovaev-filter-column<?php echo esc_attr( $column ); ?>">
				<?php if ( $events->have_posts() ) : while(  $events->have_posts() ) : $events->the_post();
					switch ( $template ) {
						case '1':
							ovaev_get_template( 'event-templates/event-type1.php' );
							break;
						case '2':
							ovaev_get_template( 'event-templates/event-type2.php' );
							break;
						case '3':
							ovaev_get_template( 'event-templates/event-type3.php' );
							break;
						case '4':
							ovaev_get_template( 'event-templates/event-type4.php' );
							break;
						case '5':
							ovaev_get_template( 'event-templates/event-type5.php' );
							break;
						case '6':
							ovaev_get_template( 'event-templates/event-type6.php' );
							break;
						default:
							ovaev_get_template( 'event-templates/event-type1.php' );
							break;
					}
				endwhile; else: wp_reset_postdata(); ?>
					<div class="search_not_found">
						<?php esc_html_e( 'No events found!', 'ovaev' ); ?>
					</div>
				<?php endif; wp_reset_postdata(); ?>
			</div>
		</div>
		<!-- Loader -->
		<div class="wrap_loader">
			<svg class="loader" width="50" height="50">
				<circle cx="25" cy="25" r="10" stroke="#a1a1a1"/>
				<circle cx="25" cy="25" r="20" stroke="#a1a1a1"/>
			</svg>
		</div>
		<input
			type="hidden"
			name="ovaev-data-filter"
			data-settings="<?php echo esc_attr( json_encode( $settings ) ); ?>"
		/>
	</div>
	<!-- Pagination -->
	<div class="filter-event-pagination">
	<?php if ( $total_pages > 1 ): ?>
		<div class="pagination-wrapper" data-total-page="<?php echo esc_attr( $total_pages ); ?>">
			<ul>
				<?php for ( $i = 1; $i <= $total_pages; $i++ ): ?>
					<?php if ( $i == 1 ): ?>
						<li>
							<span class="prev page-numbers" data-paged="<?php echo esc_attr( $current_page - 1 ); ?>">
								<?php esc_html_e( 'Previous', 'ovaev' ); ?>
							</span>
						</li>
						<li>
							<span class="page-numbers current" data-paged="<?php echo esc_attr( $i ); ?>">
								<?php echo esc_attr( $i ); ?>
							</span>
						</li>
					<?php elseif ( $i == $total_pages ): ?>
						<li>
							<span class="page-numbers" data-paged="<?php echo esc_attr( $i ); ?>">
								<?php echo esc_attr( $i ); ?>
							</span>
						</li>
						<li>
							<span class="next page-numbers" data-paged="<?php echo esc_attr( $current_page + 1 ); ?>">
								<?php esc_html_e( 'Next', 'ovaev' ); ?>
							</span>
						</li>
					<?php else: ?>
						<li>
							<span class="page-numbers" data-paged="<?php echo esc_attr( $i ); ?>">
								<?php echo esc_attr( $i ); ?>
							</span>
						</li>
					<?php endif; ?>
				<?php endfor; ?>
			</ul>
		</div>
	<?php endif; // END pagination ?>
</div>