<?php if ( !defined( 'ABSPATH' ) ) exit();

// Date format
$date_format = get_option( 'date_format' );

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args );

// Get class
$class = ovaev_get_meta_data( 'class', $args );

// Get icon
$icon = ovaev_get_meta_data( 'icon', $args );

// Get start date time
$start_datetime = get_post_meta( $event_id, 'ovaev_start_date_time', true );

// Start date
$start_date = $start_datetime ? date_i18n( $date_format, $start_datetime ) : '';

// Get end date time
$end_datetime = get_post_meta( $event_id, 'ovaev_end_date_time', true );

// End date
$end_date = $end_datetime ? date_i18n( $date_format, $end_datetime ) : '';

if ( $start_date && $end_date ): ?>
	<div class="ovaev-shortcode-date <?php echo esc_attr( $class ); ?>">
		<?php if ( $start_date == $end_date ): ?>
			<i class="<?php echo esc_attr( $icon ); ?>"></i>
			<span class="second_font"><?php echo esc_html( $start_date ); ?></span>
		<?php elseif ( $start_date != $end_date ): ?>
			<i class="<?php echo esc_html( $icon ); ?>"></i>
			<span class="second_font"><?php echo esc_html( $start_date ); ?></span>
			<span class="second_font"><?php echo esc_html_e( ' - ', 'ovaev' ); ?></span>
			<span class="second_font"><?php echo esc_html( $end_date ); ?></span>
		<?php endif; ?>
	</div>
<?php endif; ?>