<?php if ( !defined( 'ABSPATH' ) ) exit(); 

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args );

// Get post type
$post_type = get_post_type( $event_id );
if ( !$post_type || 'event' != $post_type ) return;

// Get template
$template = ovaev_get_meta_data( 'template', $args );

// Get date format
$date_format = ovaev_get_meta_data( 'date_format', $args );

// Get heading
$heading = ovaev_get_meta_data( 'heading', $args );

// Get button text
$button_text = ovaev_get_meta_data( 'text_button', $args );

// Get label day
$label_day = ovaev_get_meta_data( 'label_day', $args );

// Get label hour
$label_hour = ovaev_get_meta_data( 'label_hour', $args );

// Get label minute
$label_minute = ovaev_get_meta_data( 'label_minute', $args );

// Get label second
$label_second = ovaev_get_meta_data( 'label_second', $args );

// Get event title
$title = get_the_title( $event_id );

// Get event venue
$venue = get_post_meta( $event_id, 'ovaev_venue', true ); 

// Get start date time
$start_datetime = get_post_meta( $event_id, 'ovaev_start_date_time', true );

// Start date
$start_date = $start_datetime ? date_i18n( $date_format, $start_datetime ) : '';

// Get countdown date
$countdown_date = $start_datetime ? date_i18n( 'Y-m-d h:m:s', $start_datetime ) : '';

?>
<div
	class="ovaev-event-countdown <?php echo esc_attr( $template ); ?>"
	data-label_day="<?php echo esc_attr( $label_day ); ?>"
	data-label_hour="<?php echo esc_attr( $label_hour ); ?>"
	data-label_minute="<?php echo esc_attr( $label_minute ); ?>"
	data-label_second="<?php echo esc_attr( $label_second ); ?>"
>
	<?php if ( $heading ): ?>
		<h2 class="heading-event">
			<?php echo esc_html( $heading ); ?>
		</h2>
	<?php endif; ?>
	<div class="event-countdown">
		<h3 class="title">
    		<?php echo esc_html( $title ); ?>
    	</h3>
        <?php if ( $start_date ): ?>
            <div class="time equal-date">
                <span class="icon-time">
                    <i class="flaticon flaticon-calendar icon_event"></i>
                </span>
                <span class="time-date-child">
                    <span class="date-child">
                        <?php echo esc_html( $start_date ); ?>
                    </span>
                </span>
            </div>
        <?php endif;

        // Venue
        if ( $venue ): ?>
            <div class="venue">
                <i class="flaticon flaticon-home icon_event"></i>
                <span class="number">
                    <?php echo esc_html( $venue ); ?>
                </span>
            </div>
        <?php endif; ?>
	</div>
	<div class="countdown-timer-container">
		<?php if ( 'template1' === $template ): ?>
			<div class="countdown-timer" data-date="<?php echo esc_attr( $countdown_date ); ?>"></div>
		<?php else: ?>
			<div class="countdown-timer-not-timecircles" data-date="<?php echo esc_attr( $countdown_date ); ?>">
				<div class="timer-wrapper">
					<div class="timer" id="days"></div>
					<span class="label">
						<?php echo esc_html( $label_day ); ?>
					</span>
				</div>
				<div class="timer-wrapper">
					<div class="timer" id="hours"></div>
					<span class="label">
						<?php echo esc_html( $label_hour ); ?>
					</span>
				</div>
				<div class="timer-wrapper">
					<div class="timer" id="min"></div>
					<span class="label">
						<?php echo esc_html( $label_minute ); ?>
					</span>
				</div>
				<div class="timer-wrapper">
					<div class="timer" id="sec"></div>
					<span class="label">
						<?php echo esc_html( $label_second ); ?>
					</span>
				</div>
			</div>
		<?php endif; ?>
		<a href="<?php echo esc_url( get_the_permalink( $event_id ) ); ?>" class="join-event">
			<span class="text-button"><?php echo esc_html( $button_text ); ?></span>
			<i aria-hidden="true" class="ovaicon ovaicon-next"></i>
		</a>
	</div>
</div>