<?php if ( !defined( 'ABSPATH' ) ) exit(); 

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args );

// Get class
$class = ovaev_get_meta_data( 'class', $args );

// Get icon
$icon = ovaev_get_meta_data( 'icon', $args );

// Get event categories
$categories = get_the_terms( $event_id, 'event_category' );
$separator 	= esc_html( ', ', 'ovaev' ); 

if ( ovaev_array_exists( $categories ) ):
	$i 		= 1;
	$count 	= count( $categories );
?>
	<div class="ovaev-shortcode-categories <?php echo esc_attr( $class ); ?>">
		<i class="<?php echo esc_attr( $icon ); ?>"></i>
		<?php foreach ( $categories as $category ):
			if ( $i == $count ) {
				$separator = '';
			}

			// Get category name
			$name = $category->name;

			// Get category link
			$link = get_term_link( $category->term_id );
			if ( is_wp_error( $link ) ) continue;
		?>
		<span class="event-category">
	    	<a class="second_font" href="<?php echo esc_url( $link ); ?>">
	    		<?php echo esc_html( $name ); ?>
	    	</a>
		</span>
	    <span class="separator">
	        <?php echo esc_html( $separator ); ?>
	    </span>
		<?php $i++; endforeach; ?>
	</div>
<?php endif; ?>