<?php if ( !defined( 'ABSPATH' ) ) exit(); 

// Get event type
$event_type = ovaev_get_meta_data( 'ovaev_type', $_GET );

// Start date
$start_date = ovaev_get_meta_data( 'ovaev_start_date_search', $_GET );
$end_date 	= ovaev_get_meta_data( 'ovaev_end_date_search', $_GET );

// Query event category
if ( is_tax( 'event_category' ) || '' != get_query_var( 'event_category' ) ) {
	$event_type = get_query_var( 'event_category' );
}

// Get language
$lang = OVAEV_Settings::archive_format_date_lang();

// Get date format
$date_format = OVAEV_Settings::archive_event_format_date();

// Get time format
$time_format = OVAEV_Settings::archive_event_format_time();

// Get first day
$first_day = apply_filters( 'ovaev_calendar_first_day' , get_option( 'start_of_week' ) );

// Get archive link
$archive_link = get_post_type_archive_link( 'event' );

?>

<div class="search_archive_event">
	<form action="<?php echo esc_url( $archive_link ); ?>" method="GET" name="search_event" autocomplete="off">
		<div class="start_date">
			<label class="second_font ova-label-search">
				<?php esc_html_e( 'Start Date', 'ovaev' ); ?>
			</label>
			<input
				type="text"
				id="ovaev_start_date_search"
				class="ovaev_start_date_search"
				name="ovaev_start_date_search"
				value="<?php echo esc_attr( $start_date ); ?>"
				placeholder="<?php echo esc_attr__( 'Choose Date', 'ovaev' ); ?>"
				data-lang="<?php echo esc_attr( $lang ); ?>"
				data-date="<?php echo esc_attr( $date_format ); ?>"
				data-time="<?php echo esc_attr( $time_format ); ?>"
				data-first-day="<?php echo esc_attr( $first_day ); ?>"
			/>
			<i class="far fa-calendar-alt"></i>
		</div>
		<div class="end_date">
			<label class="second_font ova-label-search">
				<?php esc_html_e( 'End Date', 'ovaev' ); ?>
			</label>
			<input
				type="text"
				id="ovaev_end_date_search"
				class="ovaev_end_date_search"
				name="ovaev_end_date_search"
				value="<?php echo esc_attr( $end_date ); ?>"
				placeholder="<?php echo esc_attr__( 'Choose Date', 'ovaev' ); ?>"
				data-lang="<?php echo esc_attr( $lang ); ?>"
				data-date="<?php echo esc_attr( $date_format ); ?>"
				data-first-day="<?php echo esc_attr( $first_day ); ?>"
			/>
			<i class="far fa-calendar-alt"></i>
		</div>
		<div class="ovaev_cat_search">
			<label class="second_font ova-label-search" for="ovaev_type">
				<?php esc_html_e( 'Category', 'ovaev' ); ?>
			</label>
			<?php $dropdown = apply_filters( 'OVAEV_event_type', $event_type ); ?>
			<i class="arrow_carrot-down "></i>
		</div>
		<div class="wrap-ovaev_submit">
			<input
				type="submit"
				class="second_font ovaev_submit"
				value="<?php esc_attr_e( 'Find Event', 'ovaev' ); ?>"
			/>
		</div>
		<input type="hidden" name="post_type" value="event">
		<input type="hidden" name="search_event" value="search-event">
	</form>
</div>