<?php if ( !defined( 'ABSPATH' ) ) exit(); 

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args, get_the_id() );

// Get event type
$event_type = get_the_terms( $event_id, 'event_category' ) ? get_the_terms( $event_id, 'event_category' ) : '' ;

// Types
$types = [];
if ( ovaev_array_exists( $event_type ) ) {
	foreach ( $event_type as $type ) {
		$types[] = '<a class="event_type" href="' . esc_url( get_term_link( $type->term_id ) ) . '">' . esc_html( $type->name ) . '</a>' ;
	}
}

if ( ovaev_array_exists( $types ) ): ?>
	<div class="post_cat">
		<?php echo implode( ', ', $types ); ?>
	</div>
<?php endif; ?>