<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args, get_the_id() );

// Get start date time
$start_date = get_post_meta( $event_id, 'ovaev_start_date_time', true );

// Get event day
$event_day = $start_date ? date_i18n( 'd', $start_date ) : '';

// Get event month
$event_month = $start_date != '' ? date_i18n( 'F', $start_date ) : '';

// Get week day
$week_day = $start_date != '' ? date_i18n( 'l', $start_date ) : '';

if ( $event_day && $event_month && $week_day ): ?>
	<div class="date-event">
		<span class="date-month second_font">
			<?php echo esc_html( $event_day ); ?>
			<span class="month second_font">
				<?php echo esc_html( $event_month ); ?>
			</span>
		</span>
		<span class="weekday second_font">
			<?php echo esc_html( $week_day ); ?>
		</span>
	</div>
<?php endif; ?>