<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args, get_the_id() );

// Get start date time
$start_date = get_post_meta( $event_id, 'ovaev_start_date_time', true );

// Get event day
$event_day = $start_date ? date_i18n( 'd', $start_date ) : '';

// Get event month
$event_month = $start_date != '' ? date_i18n( 'M', $start_date ) : '';

if ( $event_day && $event_month ): ?>
	<div class="date-event">
		<span class="date"><?php echo esc_html( $event_day ); ?></span>
		<span class="month"><?php echo esc_html( $event_month ); ?></span>
	</div>
<?php endif; ?>