<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get event id
$event_id = ovaev_get_meta_data( 'id', $args, get_the_id() );

// Date format
$date_format = apply_filters( 'ovaev_date_event_format', get_option( 'date_format' ) );

// Time format
$time_format = OVAEV_Settings::archive_event_format_time();

// Start date
$start_date = get_post_meta( $event_id, 'ovaev_start_date_time', true );
$start_date = $start_date ? date_i18n( $date_format, $start_date ) : '';

// Start time
$start_time = strtotime( get_post_meta( $event_id, 'ovaev_start_time', true ) );
$start_time = $start_time ? date_i18n( $time_format, $start_time ) : '';

// End date
$end_date = get_post_meta( $event_id, 'ovaev_end_date_time', true );
$end_date = $end_date ? date_i18n( $date_format, $end_date ) : '';

// End time
$end_time = strtotime( get_post_meta( $event_id, 'ovaev_end_time', true ) );
$end_time = $end_time ? date_i18n( $time_format, $end_time ) : '';

if ( $start_date ): ?>
	<div class="time equal-date">
		<span class="icon-time">
			<i class="far fa-clock icon_event"></i>
		</span>
		<?php if ( $end_date && $start_date === $end_date ): ?>
			<span class="time-date-child">
				<span class="date-child">
					<?php echo esc_html( $start_date );

					// Start time
					if ( $start_time ):
						esc_html_e( '@', 'ovaev' );
					?>
						<span><?php echo esc_html( $start_time ); ?></span>
						<?php if ( $end_time ): ?>
							<span class="separation"> - </span>
							<span><?php echo esc_html( $end_time ); ?></span>
						<?php endif; ?>
					<?php endif; ?>
				</span>
			</span>
		<?php else: ?>
			<span class="time-date-child">
				<span class="date-child">
					<?php echo esc_html( $start_date ); ?>
				</span>
				<?php if ( $start_time ):
					esc_html_e( '@', 'ovaev' );
				?>
					<span><?php echo esc_html( $start_time ); ?></span>
					<?php if ( apply_filters( 'ovaev_show_more_date_text', true ) ): ?>
						<a href="<?php echo esc_url( get_the_permalink( $event_id ) ); ?>" class="more_date_text" data-id="<?php echo esc_attr( $event_id ); ?>">
							<span><?php esc_html_e( ', more', 'ovaev' ); ?></span>	
						</a>
					<?php endif;
				endif; ?>
			</span>
		<?php endif; ?>
	</div>
<?php endif;