<?php if ( !defined( 'ABSPATH' ) ) exit();

// Carousel options
$carousel_options = [
	'items' 				=> (int)ovaev_get_meta_data( 'item_number', $args ),
	'slideBy' 				=> (int)ovaev_get_meta_data( 'slides_to_scroll', $args ),
	'margin' 				=> (int)ovaev_get_meta_data( 'margin_items', $args ),
	'autoplayTimeout' 		=> (int)ovaev_get_meta_data( 'autoplay_speed', $args ),
	'smartSpeed' 			=> (int)ovaev_get_meta_data( 'smartspeed', $args ),
	'autoplayHoverPause' 	=> 'yes' === ovaev_get_meta_data( 'pause_on_hover', $args ) ? true : false,
	'loop' 					=> 'yes' === ovaev_get_meta_data( 'infinite', $args ) ? true : false,
	'autoplay' 				=> 'yes' === ovaev_get_meta_data( 'autoplay', $args ) ? true : false,
	'dots' 					=> 'yes' === ovaev_get_meta_data( 'dot_control', $args ) ? true : false,
	'nav' 					=> 'yes' === ovaev_get_meta_data( 'nav_control', $args ) ? true : false
];

// Get term
$term = get_term_by( 'name', ovaev_get_meta_data( 'category', $args ), 'event_category' );

// Get term link
$term_link = get_term_link( $term );

// Get layout
$layout = ovaev_get_meta_data( 'layout', $args );

// Get events
$events = ovaev_get_events( $args );

?>

<div class="ovaev-event-element ovaev-event-slide" >
	<div class="wp-content ovaev-slide owl-carousel" data-options="<?php echo esc_attr( json_encode( $carousel_options ) ); ?>">
		<?php if ( $events->have_posts() ) : while( $events->have_posts() ) : $events->the_post();
			switch ( $layout ) {
				case '1':
					ovaev_get_template( 'event-templates/event-type1.php' );
					break;
				case '2':
					ovaev_get_template( 'event-templates/event-type3.php' );
					break;
				default:
					ovaev_get_template( 'event-templates/event-type1.php' );
					break;
			}
		endwhile; endif; wp_reset_postdata(); ?>
	</div>
</div>