<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get category
$category = ovaev_get_meta_data( 'category', $args );

// Get filter event
$filter_event = ovaev_get_meta_data( 'filter_event', $args, 'all' );

// Get exclude cat
$exclude_cat = ovaev_get_meta_data( 'exclude_cat', $args );

// Get events
$events = OVAEV_get_data::get_events_simple_calendar( $category, $filter_event, $exclude_cat );

// Get day of the week
$days_of_the_week = ovaev_get_meta_data( 'days_of_the_week', $settings );
if ( $days_of_the_week ) {
	$days_of_the_week = explode( '|', $days_of_the_week );

	if ( ovaev_array_exists( $days_of_the_week ) ) {
		$days_of_the_week = json_encode( $days_of_the_week );
	}
}

?>

<div class="ovaev_simple_calendar" data-days-of-the-week="<?php echo esc_attr( $days_of_the_week ); ?>" events="<?php echo esc_attr( $events ); ?>">
	<div class="ovaev_events_simple_calendar cal1"></div>
</div>