<?php if ( !defined( 'ABSPATH' ) ) exit();

// Calendar language
$lang = OVAEV_Settings::archive_format_date_lang();

// Get date format
$date_format = OVAEV_Settings::archive_event_format_date();

// Get time format
$time_format = OVAEV_Settings::archive_event_format_time();

// Get settings
$settings = ovaev_get_meta_data( 'settings', $args );

// Get events
$events = ovaev_get_meta_data( 'events', $args );

// Get layout
$layout = ovaev_get_meta_data( 'layout', $args );

// Get column
$column = ovaev_get_meta_data( 'column', $args );

// Get posts per page
$posts_per_page = ovaev_get_meta_data( 'posts_per_page', $args );

// Get order
$order = ovaev_get_meta_data( 'order', $args );

// Get orderby
$orderby = ovaev_get_meta_data( 'order_by', $args );

// Get category
$category_slug = ovaev_get_meta_data( 'category', $args );

// Get event time
$time_event = ovaev_get_meta_data( 'time_event', $args );

// Total pages
$total_pages = $events->max_num_pages;

// Current page
$current_page = 1;

// First day
$first_day = apply_filters( 'ovaev_calendar_first_day' , get_option( 'start_of_week' ) );

?>

<div class="ovaev-wrapper-search-ajax">
	<!-- Search form -->
	<div class="ovaev-search-ajax-form search_archive_event">
		<form action="<?php echo esc_url( get_post_type_archive_link( 'event' ) ); ?>" method="POST" name="search_ajax_event" autocomplete="off">
			<div class="start_date">
				<label class="second_font ova-label-search">
					<?php esc_html_e( 'Start Date', 'ovaev' ); ?>
				</label>
				<input
					type="text"
					id="ovaev_start_date_search"
					class="ovaev_start_date_search"
					name="ovaev_start_date_search"
					value=""
					placeholder="<?php echo esc_attr__( 'Choose Date', 'ovaev' ); ?>"
					data-lang="<?php echo esc_attr( $lang ); ?>"
					data-date="<?php echo esc_attr( $date_format ); ?>"
					data-time="<?php echo esc_attr( $time_format ); ?>"
					data-first-day="<?php echo esc_attr( $first_day ); ?>"
				/>
				<i class="far fa-calendar-alt"></i>
			</div>
			<div class="end_date">
				<label class="second_font ova-label-search">
					<?php esc_html_e( 'End Date', 'ovaev' ); ?>
				</label>
				<input
					type="text"
					id="ovaev_end_date_search"
					class="ovaev_end_date_search"
					name="ovaev_end_date_search"
					value=""
					placeholder="<?php echo esc_attr__( 'Choose Date', 'ovaev' ); ?>"
					data-lang="<?php echo esc_attr( $lang ); ?>"
					data-date="<?php echo esc_attr( $date_format ); ?>"
					data-first-day="<?php echo esc_attr( $first_day ); ?>"
				/>
				<i class="far fa-calendar-alt"></i>
			</div>
			<div class="ovaev_cat_search">
				<label class="second_font ova-label-search" for="ovaev_type">
					<?php esc_html_e( 'Category', 'ovaev' ); ?>
				</label>
				<?php $dropdown = apply_filters( 'OVAEV_event_type', '' ); ?>
				<i class="arrow_carrot-down "></i>
			</div>
		</form>
	</div><!-- End search form -->

	<!-- Events -->
	<div class="ovaev-search-ajax-container">
		<div class="search-ajax-content">
			<div class="archive_event ovaev-search-ajax-events<?php echo ' '.esc_attr( $column );?>">
				<?php if ( $events->have_posts() ) : while( $events->have_posts() ) : $events->the_post();
					switch ( $layout ) {
						case '1':
							ovaev_get_template( 'event-templates/event-type1.php' );
							break;
						case '2':
							ovaev_get_template( 'event-templates/event-type2.php' );
							break;
						case '3':
							ovaev_get_template( 'event-templates/event-type3.php' );
							break;
						case '4':
							ovaev_get_template( 'event-templates/event-type4.php' );
							break;
						case '5':
							ovaev_get_template( 'event-templates/event-type5.php' );
							break;
						case '6':
							ovaev_get_template( 'event-templates/event-type6.php' );
							break;
						default:
							ovaev_get_template( 'event-templates/event-type1.php' );
							break;
					}

				endwhile; else: ?>
					<div class="search_not_found">
						<?php esc_html_e( 'No events found!', 'ovaev' ); ?>
					</div>
				<?php endif; wp_reset_postdata(); ?>
			</div>
			<div class="data-events" 
				data-layout="<?php echo esc_attr( $layout ); ?>" 
				data-column="<?php echo esc_attr( $column ); ?>" 
				data-per-page="<?php echo esc_attr( $posts_per_page ); ?>" 
				data-order="<?php echo esc_attr( $order ); ?>" 
				data-orderby="<?php echo esc_attr( $orderby ); ?>" 
				data-category-slug="<?php echo esc_attr( $category_slug ); ?>" 
				data-time-event="<?php echo esc_attr( $time_event ); ?>">
			</div>
		</div>
		<div class="wrap_loader">
			<svg class="loader" width="50" height="50">
				<circle cx="25" cy="25" r="10" stroke="#a1a1a1"/>
				<circle cx="25" cy="25" r="20" stroke="#a1a1a1"/>
			</svg>
		</div>
	</div><!-- End events -->

	<!-- Pagination -->
	<div class="search-ajax-pagination-wrapper">
		<?php if ( $total_pages > 1 ): ?>
			<div class="search-ajax-pagination" data-total-page="<?php echo esc_attr( $total_pages ); ?>">
				<ul>
					<?php for ( $i = 1; $i <= $total_pages; $i++ ): ?>
						<?php if ( $i == 1 ): ?>
							<li>
								<span class="prev page-numbers" data-paged="<?php echo esc_attr( $current_page - 1 ); ?>">
									<?php esc_html_e( 'Previous', 'ovaev' ); ?>
								</span>
							</li>
							<li>
								<span class="page-numbers current" data-paged="<?php echo esc_attr( $i ); ?>">
									<?php echo esc_attr( $i ); ?>
								</span>
							</li>
						<?php elseif ( $i == $total_pages ): ?>
							<li>
								<span class="page-numbers" data-paged="<?php echo esc_attr( $i ); ?>">
									<?php echo esc_attr( $i ); ?>
								</span>
							</li>
							<li>
								<span class="next page-numbers" data-paged="<?php echo esc_attr( $current_page + 1 ); ?>">
									<?php esc_html_e( 'Next', 'ovaev' ); ?>
								</span>
							</li>
						<?php else: ?>
							<li>
								<span class="page-numbers" data-paged="<?php echo esc_attr( $i ); ?>">
									<?php echo esc_attr( $i ); ?>
								</span>
							</li>
						<?php endif;
					endfor; ?>
				</ul>
			</div>
		<?php endif; ?>
	</div><!-- END pagination -->
</div>