<?php if ( !defined( 'ABSPATH' ) ) exit();

// Show filter
$show_filter = ovaev_get_meta_data( 'show_filter', $args, 'no' );

// Filter event
$filter_event = ovaev_get_meta_data( 'filter_event', $args, 'all' );

// Default view
$default_view = ovaev_get_meta_data( 'default_calendar_view', $args, 'dayGridMonth' );

// Category
$category = ovaev_get_meta_data( 'category', $args, 'all' );

// Exclude category
$exclude_cat = ovaev_get_meta_data( 'exclude_cat', $args );

// Get calendar language
$lang = OVAEV_Settings::archive_format_date_lang();

// Button text
$button_text = apply_filters( 'ovaev_calendar_button_text', [
	'today' => 'today',
  	'month' => 'month',
  	'week'	=> 'week',
  	'day' 	=> 'day',
  	'list' 	=> 'list'
]);

// Calendar view
$calendar_view = [];

// Show view month
if ( 'yes' === ovaev_get_meta_data( 'show_view_month', $args, 'yes' ) ) {
    $calendar_view[] = 'dayGridMonth';
}

// Show view week
if ( 'yes' === ovaev_get_meta_data( 'show_view_week', $args, 'yes' ) ) {
    $calendar_view[] = 'timeGridWeek';
}

// Show view day
if ( 'yes' === ovaev_get_meta_data( 'show_view_day', $args, 'yes' ) ) {
    $calendar_view[] = 'timeGridDay';
}

// Show view list
if ( 'yes' === ovaev_get_meta_data( 'show_view_list', $args, 'yes' ) ) {
    $calendar_view[] = 'listWeek';
}

$calendar_view = implode( ',', $calendar_view );

// All day text
$all_day_text = apply_filters( 'ovaev_calendar_all_day_text', esc_html__( 'all-day', 'ovaev' ) );

// No events text
$no_events_text = apply_filters( 'ovaev_calendar_no_events_text', esc_html__( 'No events to display', 'ovaev' ) );

// First day
$first_day = apply_filters( 'ovaev_calendar_first_day' , get_option( 'start_of_week' ) );

// Get events
$events = OVAEV_get_data::get_events_calendar( $category, $filter_event, $exclude_cat );

?>

<div
	class="ovaev_fullcalendar"
	full_events="<?php echo esc_attr( $events ); ?>"
	data-lang="<?php echo esc_attr( $lang ); ?>"
	data-button-text="<?php echo json_encode( $button_text ); ?>"
	data-no-events-text="<?php echo esc_attr( $no_events_text ); ?>"
	data-all-day-text="<?php echo esc_attr( $all_day_text ); ?>"
	data-first-day="<?php echo esc_attr( $first_day ); ?>"
	data-default-view="<?php echo esc_attr( $default_view ); ?>"
	data-calendar-view="<?php echo esc_attr( $calendar_view ); ?>">
	<?php if ( 'yes' === $show_filter ): ?>
		<div class="calendar_filter_event">
		  	<label for="calendar_filter_event">
		  		<?php echo esc_html__( 'Filter Event', 'ovaev' ); ?>
		  	</label>
		  	<select id="calendar_filter_event" class="form-control">
		      	<option value="all">
		      		<?php echo esc_html__( 'All', 'ovaev' ); ?>
		      	</option>
		      	<option value="past_event">
		      		<?php echo esc_html__( 'Past Event', 'ovaev' ); ?>
		      	</option>
		      	<option value="upcoming_event">
		      		<?php echo esc_html__( 'Upcoming Event', 'ovaev' ); ?>
		      	</option>
		      	<option value="special_event">
		      		<?php echo esc_html__( 'Special Event', 'ovaev' ); ?>
		      	</option>
		    </select>
		</div>
	<?php endif; ?>
	<div class="ovaev_events_fullcalendar"></div>
</div>
