<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get carousel options
$carousel_options = ovaev_get_meta_data( 'data_carousel', $args );

// Get settings
$settings = ovaev_get_meta_data( 'settings', $args );

// Get layout
$layout = ovaev_get_meta_data( 'layout', $settings, 1 );

// Get events
$events = ovaev_get_meta_data( 'data_posts', $args );
if ( !empty( $events ) ): ?>
	<div class="ovapo_project_grid full_width">
		<?php if ( 'yes' === ovaev_get_meta_data( 'show_filter', $settings ) ): ?>
			<div class="button-filter container">
				<?php if ( 'yes' === ovaev_get_meta_data( 'show_all', $settings ) ): ?>
					<button
						class="second_font"
						data-filter="<?php echo esc_attr( 'all' ); ?>"
						data-order="<?php echo esc_attr( ovaev_get_meta_data( 'order_post', $settings ) ); ?>"
						data-orderby="<?php echo esc_attr( ovaev_get_meta_data( 'orderby_post', $settings ) ); ?>"
						data-first_term="<?php echo esc_attr( ovaev_get_meta_data( 'first_term', $settings ) ); ?>"
						data-term_id_filter_string="<?php echo esc_attr( ovaev_get_meta_data( 'term_id_filter_string', $settings ) ); ?>"
						data-number_post="<?php echo esc_attr( ovaev_get_meta_data( 'number_post', $settings ) ); ?>"
						data-layout="<?php echo esc_attr( $layout ); ?>"
						data-show_featured="<?php echo esc_attr( ovaev_get_meta_data( 'show_featured', $settings ) ); ?>">
						<?php esc_html_e( 'All', 'ovaev' ); ?>
					</button>
				<?php endif;

				// Terms
				if ( count( ovaev_get_meta_data( 'terms', $settings, [] ) ) > 0 ):
					foreach ( $settings['terms'] as $term ): ?>
						<button
							class="second_font"
							data-filter="<?php echo esc_attr( $term->term_id ); ?>"
							data-order="<?php echo esc_attr( ovaev_get_meta_data( 'order_post', $settings ) ); ?>"
							data-orderby="<?php echo esc_attr( ovaev_get_meta_data( 'orderby_post', $settings ) ); ?>"
							data-first_term="<?php echo esc_attr( ovaev_get_meta_data( 'first_term', $settings ) ); ?>"
							data-term_id_filter_string="<?php echo esc_attr( ovaev_get_meta_data( 'term_id_filter_string', $settings ) ); ?>"
							data-number_post="<?php echo esc_attr( ovaev_get_meta_data( 'number_post', $settings ) ); ?>"
							data-layout="<?php echo esc_attr( $layout ); ?>"
							data-show_featured="<?php echo esc_attr( ovaev_get_meta_data( 'show_featured', $settings ) ); ?>">
							<?php esc_html_e( $term->name, 'ovaev' ); ?>
						</button>
					<?php endforeach; // END loop
				endif; ?>
			</div>
		<?php endif; ?>
		<div class="content ovapo_project_slide">
			<div  class="items grid owl-carousel" data-owl="<?php echo esc_attr( json_encode( $carousel_options ) ); ?>">
				<?php if ( $events->have_posts() ) : while( $events->have_posts() ) : $events->the_post();
					switch ( $layout ) {
						case '1':
							ovaev_get_template( 'event-templates/event-type1.php' );
							break;
						case '2':
							ovaev_get_template( 'event-templates/event-type3.php' );
							break;
						default:
							ovaev_get_template( 'event-templates/event-type1.php' );
							break;
					}
				endwhile; endif; wp_reset_postdata(); ?>
			</div>
	    	<div class="title-readmore">
				<?php if ( 'yes' === ovaev_get_meta_data( 'show_read_more', $settings ) ): ?>
				<div class="btn_grid" >
					<a href="<?php echo esc_url( get_post_type_archive_link( 'event' ) ); ?>" class="read-more second_font btn_grid_event">
						<?php echo esc_html( ovaev_get_meta_data( 'text_read_more', $settings ) ); ?>
					</a>
				</div>
				<?php endif; ?>
	    	</div>
			<div class="wrap_loader">
				<svg class="loader" width="50" height="50">
					<circle cx="25" cy="25" r="10" stroke="#a1a1a1"/>
					<circle cx="25" cy="25" r="20" stroke="#a1a1a1"/>
				</svg>
			</div>
		</div>
	</div>
<?php else: ?>
	<div class="search_not_found">
		<?php esc_html_e( 'No events found!', 'ovaev' ); ?>
	</div>
<?php endif;