<?php if ( !defined( 'ABSPATH' ) ) exit(); 

// Get version template
$version = ovaev_get_meta_data( 'version', $args );

// Column
$column = ovaev_get_meta_data( 'column', $args );

// Get column template
$column_template = ovaev_get_meta_data( 'column_template', $args );

// Get event type
$event_type = ovaev_get_meta_data( 'type_event', $args );

// Get button read more text
$button_text = ovaev_get_meta_data( 'text_read_more', $args );

// Get title
$title = ovaev_get_meta_data( 'title', $args );

// Show title
$show_title = ovaev_get_meta_data( 'show_title', $args );

// Show read more
$show_read_more = ovaev_get_meta_data( 'show_read_more', $args );

// Get category
$category = ovaev_get_meta_data( 'category', $args );

// Get term
$term = get_term_by( 'name', $category, 'event_category' );

// Get term link
$term_link = get_term_link( $term );

// Get events
$events = ovaev_get_events( $args );

?>

<div class="ovaev-event-element <?php echo esc_attr( $version ); ?>">
	<?php if ( 'yes' === $show_title && 'version_1' === $version ): ?>
		<h2 class="title-event">
			<?php echo wp_kses_post( $title ); ?>
		</h2>
	<?php endif;

	if ( ( 'yes' === $show_title || 'yes' === $show_read_more ) && ( 'version_2' === $version || 'version_3' === $version ) ): ?>
		<div class="title-readmore">
			<?php if ( 'yes' === $show_title ): ?>
				<h2 class="title-event">
					<?php echo wp_kses_post( $title ); ?>
				</h2>
			<?php endif;

			// Button
			if ( 'yes' === $show_read_more ):
				// Get archive link
				$archive_link = get_post_type_archive_link( 'event' );
			?>
				<a href="<?php echo esc_url( $archive_link ); ?>" class="read-more second_font">
					<?php echo esc_html( $button_text ); ?>
					<i data-feather="chevron-right"></i>
				</a>
			<?php endif; ?>
		</div>
	<?php endif;

	// View events
	if ( 'version_1' === $version ):
		if ( $events->have_posts() ) : while( $events->have_posts() ):
			$events->the_post();
			echo ovaev_get_template( 'elements/__content_list.php' );
		endwhile; endif; wp_reset_postdata();
	elseif ( 'version_2' === $version ): ?>
		<div class="wp-content <?php echo esc_attr( $column ); ?>">
			<?php if ( $events->have_posts() ) : while( $events->have_posts() ):
					$events->the_post();
					ovaev_get_template( 'elements/ovaev-related-content.php' );
				endwhile; endif; wp_reset_postdata();
			?>
		</div>
	<?php else: ?>
		<div class="container-event">
			<div id="main-event" class="content-event">
				<div class="archive_event <?php echo esc_attr( $column_template ); ?>">
					<?php if ( $events->have_posts() ) : while( $events->have_posts() ):
						$events->the_post();
						ovaev_get_template( 'event-templates/event-'.$event_type.'.php' ); ?>
					<?php endwhile; else: ?>
						<div class="search_not_found">
							<?php esc_html_e( 'No events found!', 'ovaev' ); ?>
						</div>
					<?php endif; wp_reset_postdata(); ?>
				</div>
			</div>
		</div>
	<?php endif; ?>
</div>