<?php if ( !defined( 'ABSPATH' ) ) exit(); 

// Get event id
$event_id = get_the_id();

// Get product id
$product_id = OVAEV_Settings::ovaev_booking_via_woo();

// Get booking via
$event_booking_via = get_post_meta( $event_id, 'event_booking_via', true );

// Get booking url
$booking_url = get_post_meta( $event_id, 'ovaev_booking_links', true );

// Get target
$target = ovaev_get_meta_data( 'target', $args ) ? '_blank' : '_self';

if ( 'default' != $product_id && 'woocommerce' === $event_booking_via ): ?>
	<div class="ovaev-booking-btn ovaev-booking-via-woo">
		<?php do_action( 'oavev_single_booking_cart' ); ?>
	</div>
<?php else:
	if ( $booking_url && 'custom_link' === $event_booking_via ): ?>
		<div class="ovaev-booking-btn">
			<a href="<?php echo esc_url( $booking_url ); ?>" target="<?php echo esc_attr( $target ); ?>">
				<?php esc_html_e( 'Booking Now', 'ovaev' ); ?>
			</a>
		</div>
	<?php endif;
endif; ?>