<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get icon
$icon = ovaev_get_meta_data( 'icon', $args, [
	'value' 	=> 'fas fa-arrow-right',
	'library' 	=> 'fa-solid'
]);

// Get view details text
$text_view_details = ovaev_get_meta_data( 'label_view_details', $args, esc_html__( 'View detail', 'ovaev' ) );

// Get categories
$categories = ovaev_get_meta_data( 'categories', $args );

// Carousel options
$carousel_options = [
	'items' 				=> (int)ovaev_get_meta_data( 'item_number', $args ),
	'slideBy' 				=> (int)ovaev_get_meta_data( 'slides_to_scroll', $args ),
	'margin' 				=> (int)ovaev_get_meta_data( 'margin_items', $args ),
	'autoplayTimeout' 		=> (int)ovaev_get_meta_data( 'autoplay_speed', $args ),
	'smartSpeed' 			=> (int)ovaev_get_meta_data( 'smartspeed', $args ),
	'autoplayHoverPause' 	=> 'yes' === ovaev_get_meta_data( 'pause_on_hover', $args ) ? true : false,
	'loop' 					=> 'yes' === ovaev_get_meta_data( 'infinite', $args ) ? true : false,
	'autoplay' 				=> 'yes' === ovaev_get_meta_data( 'autoplay', $args ) ? true : false,
	'dots' 					=> 'yes' === ovaev_get_meta_data( 'dot_control', $args ) ? true : false,
];

// Query term
$args_term = [
	'orderby' 		=> 'slug', 
	'hide_empty' 	=> false
];

// Categories
if ( '' != $categories ) {
	$args_term['include'] = $categories;
}

// Get terms
$terms = get_terms( 'event_category', $args_term );
if ( ovaev_array_exists( $terms ) ): ?>
	<div class="ovaev-categories-slide">
		<div class="categories-slide owl-carousel" data-options="<?php echo esc_attr( json_encode( $carousel_options ) ); ?>">
			<?php foreach ( $terms as $term ):
				// Default thumbnail
				$default_thumbnail = OVAEV_PLUGIN_URI . 'assets/img/woocommerce-placeholder-600x600.png';

				// Get thumbnail id
				$thumbnail_id = get_term_meta( $term->term_id, 'event_cat_thumbnail_id', true );

				// Get thumbnail URL
				$thumbnail_url = wp_get_attachment_url( $thumbnail_id );
				if ( !$thumbnail_url ) $thumbnail_url = $default_thumbnail;

				// Get term name
				$name = $term->name;

				// Get term link
				$link = get_term_link( $term->term_id, 'event_category' );
				if ( is_wp_error( $link ) ) $link = '';
			?>
				<div class="item">
					<div class="image-thumbnail">
						<img src="<?php echo esc_url( $thumbnail_url ); ?>" alt="<?php echo esc_html( $name ); ?>">
						<?php if ( $text_view_details || ovaev_array_exists( $icon ) ): ?>
							<a href="<?php echo esc_url( $link ); ?>" class="btn read-more">
								<span><?php echo esc_html( $text_view_details ); ?></span>
								<?php if ( ovaev_array_exists( $icon ) ) { 
								    \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
								} ?>
							</a>
						<?php endif; ?>
					</div>
					<h4 class="title">
						<a href="<?php echo esc_url( $link ); ?>" >
							<?php echo esc_html( $name ); ?>
							<span class="count">
								<?php echo '(' . esc_html( $term->count ) . ')'; ?>
							</span>
						</a>
					</h4>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>