<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get date format
$date_format = get_option( 'date_format' );

// Get time format
$time_format = get_option( 'time_format' );

// Get event id
$event_id = get_the_ID();

// Get start date time
$start_datetime = get_post_meta( $event_id, 'ovaev_start_date_time', true );

// Get end date time
$end_datetime = get_post_meta( $event_id, 'ovaev_end_date_time', true );

// Start date
$start_date = $start_time = '';
if ( $start_datetime ) {
	$start_date = date_i18n( $date_format, $start_datetime );
	$start_time = date_i18n( $time_format, $start_datetime );
}

// End date
$end_date = $end_time = '';
if ( $end_datetime ) {
	$end_date = date_i18n( $date_format, $end_datetime );
	$end_time = date_i18n( $time_format, $end_datetime );
}

?>

<div class="item">
	<h3 class="title">
		<a class="second_font" href="<?php echo esc_url( get_the_permalink( $event_id ) ); ?>">
			<?php echo wp_kses_post( get_the_title( $event_id ) ); ?>
		</a>
	</h3>
	<div class="time-event">
		<?php if ( $start_date && $end_date && $start_date === $end_date ): ?>
			<div class="time">
				<span>
					<?php echo sprintf( esc_html__( '%s @ %s - %s', 'ovaev' ), $start_date, $start_time, $end_time ); ?>
				</span>
			</div>
		<?php elseif ( $start_date && $end_date && $start_date != $end_date ): ?>
			<div class="time">
				<span>
					<?php echo sprintf( esc_html__( '%s - %s', 'ovaev' ), $start_date, $end_date ); ?>
				</span>
			</div>
		<?php endif; ?>
	</div>
</div>