<?php if ( !defined( 'ABSPATH' ) ) exit();

// Get header
get_header();

// Get template
$template = ovaev_get_meta_data( 'event_type_temp', $_GET, OVAEV_Settings::archive_event_type() );

// Get columns
$columns = ovaev_get_meta_data( 'col', $_GET, OVAEV_Settings::archive_event_col() );

// Show sidebar
$show_sidebar = ovaev_get_meta_data( 'show_sidebar', $_GET, OVAEV_Settings::ovaev_show_sidebar() );

// Class
$active_sidebar = 'main-event';
if ( 'yes' === $show_sidebar && is_active_sidebar('event-sidebar') ) {
	$active_sidebar = 'sidebar-active';
}

?>

<div class="container-event">
	<div id="<?php echo esc_attr( $active_sidebar ); ?>" class="content-event">
		<?php // Search form
			do_action( 'ovaev_search_form' );
		?>
		<div class="archive_event <?php echo esc_attr( $columns ); ?>">
			<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
				ovaev_get_template( 'event-templates/event-'.sanitize_file_name( $template ).'.php' );
			endwhile; else: ?>
				<div class="search_not_found">
					<?php esc_html_e( 'No events found!', 'ovaev' ); ?>
				</div>
			<?php endif; wp_reset_postdata(); ?>

		</div>
		<?php global $wp_query;
		// Pagination
		if ( $wp_query->max_num_pages > 1 ): ?>
			<div class="events_pagination">
				<?php echo paginate_links( apply_filters( 'el_pagination_args', [
					'base'         => esc_url_raw( str_replace( 999999999, '%#%', get_pagenum_link( 999999999, false ) ) ),
					'format'       => '',
					'add_args'     => '',
					'current'      => max( 1, get_query_var( 'paged' ) ),
					'total'        => $wp_query->max_num_pages,
					'prev_text'    => esc_html__( 'Previous', 'ovaev' ),
					'next_text'    => esc_html__( 'Next', 'ovaev' ),
					'type'         => 'list',
					'end_size'     => 3,
					'mid_size'     => 3
				])); ?>
			</div>
		<?php endif; ?>
	</div>
	<?php if ( 'yes' === $show_sidebar ) {
		ovaev_get_template( 'sidebar-event.php' );
	} ?>
</div>

<?php get_footer();