<?php defined( 'ABSPATH' ) || exit;

if( !class_exists( 'ovaev_shortcode_fullcalendar' ) ) {

	class ovaev_shortcode_fullcalendar {

		public $shortcode = 'ovaev_fullcalendar';

		public function __construct() {
			//add shortcode
			add_shortcode( $this->shortcode, array( $this, 'init_shortcode' ) );
		}

		function init_shortcode( $args, $content = null ) {
			//get content
			$content = get_the_content( get_the_ID() );

			//check shortcode
			if ( is_page() && has_shortcode( $content, 'ovaev_fullcalendar') ) {
				wp_enqueue_script( 'moment', OVAEV_PLUGIN_URI. 'assets/libs/calendar/moment.min.js', [ 'jquery' ], false, true );
				wp_enqueue_script( 'clndr', OVAEV_PLUGIN_URI.'assets/libs/calendar/clndr.min.js', [ 'jquery' ], true, false );
			}
			
			//check variable shortcode
			if ( !empty($args) ) {
				$attr = [
					'category' 				=> isset( $args['category'] ) ? $args['category'] : 'all',
					'exclude_cat' 			=> isset( $args['exclude_cat'] ) ? $args['exclude_cat'] : '',
					'filter_event' 			=> isset( $args['filter_event'] ) ? $args['filter_event'] : 'all',
					'default_calendar_view' => isset( $args['default_calendar_view'] ) ? $args['default_calendar_view'] : 'dayGridMonth',
					'show_filter' 			=> isset( $args['show_filter'] ) ? $args['show_filter'] : 'no',
					'show_view_month' 		=> isset( $args['show_view_month'] ) ? $args['show_view_month'] : 'yes',
					'show_view_week' 		=> isset( $args['show_view_week'] ) ? $args['show_view_week'] : 'yes',
					'show_view_day' 		=> isset( $args['show_view_day'] ) ? $args['show_view_day'] : 'yes',
					'show_view_list' 		=> isset( $args['show_view_list'] ) ? $args['show_view_list'] : 'yes',
				];
			} else {
				$attr = [
					'category' 				=> 'all',
					'exclude_cat' 			=> '',
					'filter_event' 			=> 'all',
					'default_calendar_view' => 'dayGridMonth',
					'show_filter' 			=> 'no',
					'show_view_month' 		=> 'yes',
					'show_view_week' 		=> 'yes',
					'show_view_day' 		=> 'yes',
					'show_view_list' 		=> 'yes',
				];
			}

			//get template
			$template = apply_filters( 'shortcode_ovaev_simple_fullcalendar', 'elements/ovaev_events_calendar_content.php' );

			ob_start();
			ovaev_get_template( $template, $attr );
			return ob_get_clean();
		}
	}

	new ovaev_shortcode_fullcalendar();
}
