<?php defined( 'ABSPATH' ) || exit;

if( !class_exists( 'ovaev_shortcode_countdown' ) ) {

	class ovaev_shortcode_countdown {

		public $shortcode = 'ovaev_shortcode_countdown';

		public function __construct() {
			//add shortcode
			add_shortcode( $this->shortcode, array( $this, 'init_shortcode' ) );
		}

		function init_shortcode( $args, $content = null ) {
			//get content
			$content = get_the_content( get_the_ID() );

			//check shortcode
			if ( is_page() && has_shortcode( $content, 'ovaev_shortcode_countdown') ) {
				wp_enqueue_script( 'timeCircles', OVAEV_PLUGIN_URI. 'assets/libs/timecircles/timeCircles.js', [ 'jquery' ], false, true );
				wp_enqueue_style( 'timeCircles', OVAEV_PLUGIN_URI.'assets/libs/timecircles/timeCircles.css' );
			}

			if ( !empty( $args ) ) {
				$args = [
					'id' 			=> isset( $args['id'] ) 		  ? (int)$args['id'] 		: get_the_id(),
					'template'  	=> isset( $args['template'] ) 	  ? $args['template'] 		: 'template1',
					'date_format'   => isset( $args['date_format'] )  ? $args['date_format'] 	: 'm/d/Y',
					'heading'   	=> isset( $args['heading'] ) 	  ? $args['heading'] 		: esc_html__('Upcoming Event','ovaev'),
					'text_button'   => isset( $args['text_button'] )  ? $args['text_button']	: esc_html__('Join Events','ovaev'),
					'label_day'   	=> isset( $args['label_day'] )    ? $args['label_day'] 		: esc_html__('Days','ovaev'),
					'label_hour'   	=> isset( $args['label_hour'] )   ? $args['label_hour'] 	: esc_html__('Hours','ovaev'),
					'label_minute'  => isset( $args['label_minute'] ) ? $args['label_minute'] 	: esc_html__('Minutes','ovaev'),
					'label_second'  => isset( $args['label_second'] ) ? $args['label_second'] 	: esc_html__('Seconds','ovaev'),
				];
			} else {
				$args = [
					'id' 			=> get_the_id(),
					'template' 		=> 'template1',
					'date_format' 	=> 'm/d/Y',
					'heading' 		=> esc_html__('Upcoming Event','ovaev'),
					'text_button' 	=> esc_html__('Join Events','ovaev'),
					'label_day' 	=> esc_html__('Days','ovaev'),
					'label_hour' 	=> esc_html__('Hours','ovaev'),
					'label_minute' 	=> esc_html__('Minutes','ovaev'),
					'label_second' 	=> esc_html__('Seconds','ovaev'),
				];
			}

			$template = apply_filters( 'shortcode_ovaev_countdown', 'shortcode/ovaev_event_countdown.php' );

			ob_start();
			ovaev_get_template( $template, $args );
			return ob_get_clean();
		}
	}

	new ovaev_shortcode_countdown();
}
