<?php
/*
Plugin Name: FullEvents - Ovatheme Events
Plugin URI: https://themeforest.net/user/ovatheme
Description: Ovatheme Events
Author: Ovatheme
Version: 1.3.0
Author URI: https://themeforest.net/user/ovatheme/portfolio
Text Domain: ovaev
Domain Path: /languages/
*/

if ( !defined( 'ABSPATH' ) ) exit();

/**
 * Class OVAEV
 */
if ( !class_exists( 'OVAEV' ) ) {
    
    class OVAEV {

        /**
         * Instance
         */
        protected static $_instance = null;

        /**
         * Cart Session
         */
        public $cart_session = null;

        /**
         * Constructor
         */
        public function __construct() {
            $this->define_constants();
            $this->includes();
            $this->supports();
            $this->cart_session = OVAEV_Sessions::instance('cart_session');
        }

        /**
         * Define constants
         */
        public function define_constants() {
            $this->define( 'OVAEV_PLUGIN_FILE', __FILE__ );
            $this->define( 'OVAEV_PLUGIN_URI', plugin_dir_url( __FILE__ ) );
            $this->define( 'OVAEV_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
            load_plugin_textdomain( 'ovaev', false, basename( dirname( __FILE__ ) ) .'/languages' );
        }

        /**
         * Define
         */
        public function define( $name, $value ) {
            if ( !defined( $name ) ) define( $name, $value );
        }

        /**
         * Instance
         */
        public static function instance() {
            if ( !empty( self::$_instance ) ) {
                return self::$_instance;
            }

            return self::$_instance = new self();
        }

        /**
         * Includes
         */
        public function includes() {
            // Assets
            require_once( OVAEV_PLUGIN_PATH.'inc/class-ovaev-assets.php' );

            // Register post type
            require_once( OVAEV_PLUGIN_PATH.'inc/class-ovaev-custom-post-type.php' );

            // Get data
            require_once( OVAEV_PLUGIN_PATH.'inc/class-ovaev-get-data.php' );

            // Woo
            require_once( OVAEV_PLUGIN_PATH.'inc/class-ovaev-payment-woo.php' );

            // Sessions
            require_once( OVAEV_PLUGIN_PATH.'inc/class-ovaev-sessions.php' );

            // Settings
            require_once( OVAEV_PLUGIN_PATH.'inc/class-ovaev-settings.php' );

            // Templates
            require_once( OVAEV_PLUGIN_PATH.'inc/class-ovaev-templates-loaders.php' );

            // Functions
            require_once( OVAEV_PLUGIN_PATH.'inc/ovaev-core-functions.php' );

            // Hooks
            require_once( OVAEV_PLUGIN_PATH.'inc/ovaev-hooks.php' );

            // Ajaxs
            require_once( OVAEV_PLUGIN_PATH.'inc/ovaev-data-ajax.php' );

            // Meta-boxes
            require_once( OVAEV_PLUGIN_PATH.'admin/class-ovaev-metaboxes.php' );

            // Register widgets
            require_once( OVAEV_PLUGIN_PATH.'admin/ovaev-widget.php' );

            // Admin
            if ( is_admin() ){
                require_once( OVAEV_PLUGIN_PATH.'admin/class-ovaev-admin.php' );
            }

            // Shortcodes
            require_once( OVAEV_PLUGIN_PATH.'shortcode/class-ovaev-shortcode.php' );
        }

        // Supports
        public function supports() {
            // Register new widgets
            if ( did_action( 'elementor/loaded' ) ) {
                include OVAEV_PLUGIN_PATH.'elementor/class-ova-register-elementor.php';
            }

            // Get archive event thumbnail
            $archive_event_thumbnail = OVAEV_Settings::archive_event_thumbnail('700x450');

            // Convert
            $thumbnail_args = explode( 'x', $archive_event_thumbnail );
            
            // Default thumbnail width
            $thumb_w = '700';

            // Default thumbnail height
            $thumb_h = '450';

            // Get thumbnail width
            if ( is_array( $thumbnail_args ) ) {
                $thumb_w = isset( $thumbnail_args[0] ) ? $thumbnail_args[0] : '700';
            }

            // Get thumbnail height
            if ( is_array( $thumbnail_args ) ) {
                $thumb_h = isset( $thumbnail_args[1] ) ? $thumbnail_args[1] : '450';
            }

            // Add image size
            add_image_size( 'ovaev_event_thumbnail', $thumb_w, $thumb_h, true );
        }
    }
}

// OVAEV funciton
function OVAEV() {
    return OVAEV::instance();
}

// Set OVAEV global
$GLOBALS['OVAEV'] = OVAEV();