<?php if ( !defined( 'ABSPATH' ) ) exit();

/**
 * Dump & die
 */
if ( !function_exists( 'dd' ) ) {
    function dd( ...$args ) {
        echo '<pre>';
        var_dump( ...$args );
        echo '</pre>';
        die;
    }
}

/**
 * Check array exists
 */
if ( !function_exists( 'ovaev_array_exists' ) ) {
    function ovaev_array_exists( $arr ) {
        if ( !empty( $arr ) && is_array( $arr ) ) {
            return true;
        }

        return false;
    }
}

/**
 * Get meta data
 */
if ( !function_exists( 'ovaev_get_meta_data' ) ) {
    function ovaev_get_meta_data( $key = '', $args = [], $default = false ) {
        $value = '';

        if ( '' !== $key && ovaev_array_exists( $args ) ) {
            $value = isset( $args[$key] ) ? $args[$key] : '';
        }

        // Set default
        if ( empty( $value ) && false !== $default ) {
            $value = $default;
        }

        return apply_filters( 'ovaev_get_meta_data', $value, $key, $args, $default );
    }
}

/**
 * Get locate template
 */
if ( !function_exists( 'ovaev_locate_template' ) ) {
    function ovaev_locate_template( $template_name, $template_path = '', $default_path = '' ) {
        // Set variable to search in ovaev-templates folder of theme.
        if ( !$template_path ) :
            $template_path = 'ovaev-templates/';
        endif;

        // Set default plugin templates path.
        if ( ! $default_path ) :
            $default_path = OVAEV_PLUGIN_PATH . 'templates/'; // Path to the template folder
        endif;

        // Search template file in theme folder.
        $template = locate_template( array(
            $template_path . $template_name
            // $template_name
        ) );

        // Get plugins template file.
        if ( ! $template ) :
            $template = $default_path . $template_name;
        endif;

        return apply_filters( 'ovaev_locate_template', $template, $template_name, $template_path, $default_path );
    }
}

/**
 * Get template
 */
if ( !function_exists( 'ovaev_get_template' ) ) {
    function ovaev_get_template( $template_name, $args = array(), $tempate_path = '', $default_path = '' ) {
        if ( is_array( $args ) && isset( $args ) ) :
            extract( $args );
        endif;
        $template_file = ovaev_locate_template( $template_name, $tempate_path, $default_path );
        if ( ! file_exists( $template_file ) ) :
          _doing_it_wrong( __FUNCTION__, sprintf( '<code>%s</code> does not exist.', $template_file ), '1.0.0' );
          return;
        endif;

        include $template_file;
    }
}

/**
 * Check array exists
 */
if ( !function_exists( 'ovaev_array_exists' ) ) {
    function ovaev_array_exists( $arr ) {
        if ( !empty( $arr ) && is_array( $arr ) ) {
            return true;
        }

        return false;
    }
}

/**
 * Get meta data
 */
if ( !function_exists( 'ovaev_get_meta_data' ) ) {
    function ovaev_get_meta_data( $key = '', $args = [], $default = false ) {
        $value = '';

        if ( '' !== $key && ovaev_array_exists( $args ) ) {
            $value = isset( $args[$key] ) ? $args[$key] : '';
        }

        // Set default
        if ( empty( $value ) && false !== $default ) {
            $value = $default;
        }

        return apply_filters( 'ovaev_get_meta_data', $value, $key, $args, $default );
    }
}

/**
 * Event sidebar
 */
add_action( 'widgets_init', function() {
    register_sidebar([
        'name'          => esc_html__( 'Event Sidebar', 'ovaev' ),
        'id'            => 'event-sidebar',
        'description'   => esc_html__( 'Display in event sidebar', 'ovaev' ),
        'class'         => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>'
    ]);
});

/**
 * Get event category by id
 */
if ( !function_exists( 'ovaev_get_category_event_by_id' ) ) {
    function ovaev_get_category_event_by_id( $event_id = '' ) {
        if ( !$event_id ) return;

        // Get event categories
        $event_categories = get_the_terms( $event_id, 'event_category' );

        // Flat
        $flag = 0;

        if ( ovaev_array_exists( $event_categories ) && !is_wp_error( $event_categories ) ):
            $count = count( $event_categories );
        ?>
            <i class="fa fa-list-alt"></i>
            <?php foreach ( $event_categories as $cat ):
                $flag++;
                $separator = ( $count !== $flag ) ? "," : "";

                // Get category link
                $link = get_term_link( $cat->term_id );
                if ( is_wp_error( $link ) ) continue;

                // Get category name
                $name = $cat->name;
            ?>
                <span class="cat-ovaev">
                    <a class="second_font" href="<?php echo esc_url( $link ); ?>">
                        <?php echo esc_html( $name ); ?>
                    </a>
                </span>
                <span class="separator">
                    <?php echo esc_html( $separator ); ?>
                </span>
            <?php endforeach; // END loop event categories
        endif; // END if
    }
}

/**
 * Get event tag by id
 */
if ( !function_exists( 'ovaev_get_tag_event_by_id' ) ) {
    function ovaev_get_tag_event_by_id ( $event_id = '' ) {
        if ( !$event_id ) return;

        // Get event tags
        $event_tags = get_the_terms( $event_id, 'event_tag' );

        if ( ovaev_array_exists( $event_tags ) ): ?>
            <div class="event-tags">
                <span class="ovatags second_font">
                    <?php esc_html_e( 'Tags: ', 'ovaev' ); ?>
                </span>
                <?php foreach ( $event_tags as $tag ):
                    // Get tag link
                    $link = get_term_link( $tag->term_id );
                    if ( is_wp_error( $link ) ) continue;

                    // Get tag name
                    $name = $tag->name;
                ?>
                    <a class="ovaev-tag second_font" href="<?php echo esc_url( $link ); ?>">
                        <?php echo esc_html( $name ); ?>         
                    </a>
                <?php endforeach; ?>
            </div>
            <?php
        endif; // END if
    }
}

/**
 * Get event related by id
 */
if ( !function_exists( 'ovaev_get_event_related_by_id' ) ) {
    function ovaev_get_event_related_by_id( $event_id = '' ) {
        if ( !$event_id ) return;

        // Event type query
        $type_query = [];

        // Get event types
        $event_types = get_the_terms( $event_id, 'event_category' );
        if ( ovaev_array_exists( $event_types ) ) {
            foreach ( $event_types as $type ){
                $type_query[] = $type->term_id;
            }
        }

        // Event tag query
        $tag_query = [];

        // Get event tags
        $event_tags = get_the_terms( $event_id, 'event_tag' );
        if ( ovaev_array_exists( $event_tags ) ) {
            foreach ( $event_tags as $tag ) {
                $tag_query[] = $tag->term_id;
            }
        }

        // Event related query
        $args_related = [
            'post_type'         => 'event',
            'posts_per_page'    => apply_filters( 'ovaev_single_related_count', 2 ),
            'post__not_in'      => [ $event_id ],
            'tax_query'         => [
                'relation' => 'OR',
                [
                    'taxonomy' => 'event_category',
                    'field'    => 'term_id',
                    'terms'    => $type_query
                ],
                [
                    'taxonomy' => 'event_tag',
                    'field'    => 'term_id',
                    'terms'    => $tag_query
                ]
            ]
        ];

        // Event time query
        $args_time  = [];
        $time       = apply_filters( 'ovaev_single_related_time', '' );

        if ( 'upcoming' === $time ) {
            $args_time = [
                'meta_query' => [
                    [
                        'key'     => 'ovaev_start_date_time',
                        'value'   => current_time( 'timestamp' ),
                        'compare' => '>'
                    ]
                ]
            ];
        } elseif ( 'past' === $time ) {
            $args_time = [
                'meta_query' => [
                    [
                        'key'     => 'ovaev_end_date_time',
                        'value'   => current_time( 'timestamp' ),
                        'compare' => '<'
                    ]
                ]
            ];
        }

        // Get events
        $event_related = new WP_Query( array_merge_recursive( $args_related, $args_time ) );

        return apply_filters( 'ovaev_get_event_related_by_id', $event_related, $event_id );
    }
}

/**
 * Get events
 */
if ( !function_exists( 'ovaev_get_events' ) ) {
    function ovaev_get_events( $args ) {
        // Get event category
        $event_cat = ovaev_get_meta_data( 'category', $args );

        // Event time
        $event_time = ovaev_get_meta_data( 'time_event', $args );

        // Posts per page
        $posts_per_page = (int)ovaev_get_meta_data( 'total_count', $args, -1 );

        // Orderby
        $orderby = ovaev_get_meta_data( 'order_by', $args );

        // Order
        $order = ovaev_get_meta_data( 'order', $args );

        // Query event
        $args_event = [
            'post_type'      => 'event',
            'post_status'    => 'publish',
            'posts_per_page' => $posts_per_page
        ];

        // Query event category
        if ( 'all' === $event_cat ) {
            if ( 'current' === $event_time ) {
                $args_event = [
                    'post_type'      => 'event',
                    'post_status'    => 'publish',
                    'posts_per_page' => $args['total_count'],
                    'meta_query'     => [
                        'relation' => 'AND',
                        [
                            'key'     => 'ovaev_start_date_time',
                            'value'   => current_time('timestamp' ),
                            'compare' => '<'
                        ],
                        [
                            'key'     => 'ovaev_end_date_time',
                            'value'   => current_time('timestamp' ),
                            'compare' => '>='
                        ]
                    ]
                ];
            } elseif ( 'upcoming' === $event_time ) {
                $args_event = [
                    'post_type'      => 'event',
                    'post_status'    => 'publish',
                    'posts_per_page' => $args['total_count'],
                    'meta_query'     => [
                        [
                            'key'     => 'ovaev_start_date_time',
                            'value'   => current_time( 'timestamp' ),
                            'compare' => '>'
                        ]
                    ]
                ];
            } elseif ( 'past' === $event_time ) {
                $args_event = [
                    'post_type'      => 'event',
                    'post_status'    => 'publish',
                    'posts_per_page' => $args['total_count'],
                    'meta_query'     => [
                        [
                            'key'     => 'ovaev_end_date_time',
                            'value'   => current_time('timestamp' ),
                            'compare' => '<'
                        ]
                    ]
                ];
            }

            // Get exclude category
            $exclude_cat = ovaev_get_meta_data( 'exclude_cat', $args );
            if ( $exclude_cat ) {
                $args_event['tax_query'] = [
                    [
                        'taxonomy' => 'event_category',
                        'field'    => 'term_id',
                        'terms'    => explode( ',', $exclude_cat ),
                        'operator' => 'NOT IN'
                    ]
                ];
            } // END if
        } elseif ( 'all' != $event_cat ) {
            if ( 'current' === $event_time ) {
                $args_event = [
                    'post_type'      => 'event',
                    'post_status'    => 'publish',
                    'posts_per_page' => $args['total_count'],
                    'tax_query'      => [
                        [
                            'taxonomy' => 'event_category',
                            'field'    => 'slug',
                            'terms'    => $event_cat
                        ]
                    ],
                    'meta_query'     => [
                        'relation' => 'OR',
                        [
                            'key'     => 'ovaev_start_date_time',
                            'value'   => [
                                current_time( 'timestamp' ) - 1,
                                current_time( 'timestamp' ) + ( 24*60*60 ) + 1
                            ],
                            'type'    => 'numeric',
                            'compare' => 'BETWEEN'  
                        ],
                        [
                            'relation' => 'AND',
                            [
                                'key'     => 'ovaev_start_date_time',
                                'value'   => current_time( 'timestamp' ),
                                'compare' => '<'
                            ],
                            [
                                'key'     => 'ovaev_end_date_time',
                                'value'   => current_time('timestamp' ),
                                'compare' => '>='
                            ]
                        ]
                    ]
                ];
            } elseif ( 'upcoming' === $event_time ) {
                $args_event = [
                    'post_type'      => 'event',
                    'post_status'    => 'publish',
                    'posts_per_page' => $args['total_count'],
                    'tax_query'      => [
                        [
                            'taxonomy' => 'event_category',
                            'field'    => 'slug',
                            'terms'    => $args['category']
                        ]
                    ],
                    'meta_query'     => [
                        [
                            'key'     => 'ovaev_start_date_time',
                            'value'   => current_time( 'timestamp' ),
                            'compare' => '>'
                        ]
                    ]
                ];
            } elseif ( 'past' === $event_time ) {
                $args_event = [
                    'post_type'      => 'event',
                    'post_status'    => 'publish',
                    'posts_per_page' => $args['total_count'],
                    'tax_query'      => [
                        [
                            'taxonomy' => 'event_category',
                            'field'    => 'slug',
                            'terms'    => $args['category']
                        ]
                    ],
                    'meta_query'     => [
                        [
                            'key'     => 'ovaev_end_date_time',
                            'value'   => current_time('timestamp' ),
                            'compare' => '<'
                        ]
                    ]
                ];
            } else {
                $args_event = [
                    'post_type'         => 'event',
                    'post_status'       => 'publish',
                    'posts_per_page'    => $posts_per_page,
                    'tax_query'         => [
                        [
                            'taxonomy' => 'event_category',
                            'field'    => 'slug',
                            'terms'    => explode( ',', $event_cat )
                        ]
                    ]
                ];
            } 
        }

        // Orderby
        if ( 'ovaev_start_date_time' === $orderby || 'event_custom_sort' === $orderby ) {
            $args_event['meta_key'] = $orderby;
            $args_event['orderby']  = 'meta_value_num';
        } else {
            $args_event['orderby'] = $orderby;
        }

        // Order
        $args_event['order'] = $order;

        // Get events
        $events = new \WP_Query( apply_filters( 'ovaev_query_get_events', $args_event, $args ) );

        return apply_filters( 'ovaev_get_events', $events, $args );
    }
}

/**
 * Get all events
 */
if ( !function_exists( 'ovaev_get_all_events' ) ) {
    function ovaev_get_all_events() {
        // Get events
        $events = get_posts([
            'post_type'         => 'event',
            'fields'            => 'ids', 
            'post_status'       => 'publish',
            'posts_per_page'    => '-1',
            'orderby'           => 'ID',
            'order'             => 'ASC'
        ]);

        return apply_filters( 'ovaev_get_all_events', $events );
    }
}

/**
 * Get event categories
 */
if ( !function_exists( 'ovaev_get_event_categories' ) ) {
    function ovaev_get_event_categories( $events, $incl = [], $excl = [] ) {
        // Init
        $results = $names = [];

        if ( $events->have_posts() ) {
            while ( $events->have_posts() ) {
                $events->the_post(); 
                $terms = get_the_terms( get_the_ID(), 'event_category' );

                if ( ovaev_array_exists( $terms ) ) {
                    foreach ( $terms as $term ) {
                        $term_id    = $term->term_id;
                        $term_name  = $term->name;
                        $term_slug  = $term->slug;

                        if ( $excl && in_array( $term_id, $excl ) ) continue;

                        if ( $incl ) {
                            if ( in_array( $term_id, $incl ) ) {
                                if ( ovaev_get_meta_data( $term_id, $results ) ) {
                                    $results[$term_id]['count'] += 1;
                                } else {
                                    $results[$term_id] = [
                                        'term_id'       => $term_id,
                                        'name'          => $term_name,
                                        'slug'          => $term_slug,
                                        'count'         => 1,
                                        'icon_class'    => get_term_meta( $term_id, 'ovaev_icon_class', true ),
                                    ];

                                    $names[$term_id] = $term_name;
                                }
                            }
                        } else {
                            if ( ovaev_get_meta_data( $term_id, $results ) ) {
                                $results[$term_id]['count'] += 1;
                            } else {
                                $results[$term_id] = [
                                    'term_id'       => $term_id,
                                    'name'          => $term_name,
                                    'slug'          => $term_slug,
                                    'count'         => 1,
                                    'icon_class'    => get_term_meta( $term_id, 'ovaev_icon_class', true ),
                                ];

                                $names[$term_id] = $term_name;
                            }
                        }
                    }
                }
            }
        }
        wp_reset_postdata();

        if ( ovaev_array_exists( $names ) && ovaev_array_exists( $results ) ) {
            array_multisort( $names, SORT_ASC, $results );
        }

        return apply_filters( 'ovaev_get_event_categories', $results, $events, $incl, $excl );
    }
}

/**
 * Get end date
 */
if ( !function_exists( 'ovaev_get_end_date' ) ) {
    function ovaev_get_end_date( $time = '' ) {
        // init
        $end_date = '';

        // Get date format
        $date_format = OVAEV_Settings::archive_event_format_date();

        // Today
        $today = current_time( 'timestamp' );

        if ( 'today' === $time ) {
            $end_date = strtotime( gmdate( $date_format, $today ) . ' 23:59' );
        } elseif ( 'week' === $time || 'weekend' === $time ) {
            $end_date = strtotime( gmdate( $date_format, strtotime( 'this Sunday' ) ) . ' 23:59' );
        } else {
            $end_date = $today;
        }

        return apply_filters( 'ovaev_get_end_date', $end_date, $time );
    }
}

/**
 * Get checkout woo page
 */
if ( !function_exists( 'ovaev_get_checkout_woo_page' ) ) { 
    function ovaev_get_checkout_woo_page() {
        // Get checkout page id
        $checkout_page_id =  get_option( 'woocommerce_checkout_page_id' ) ;

        // Get checkout page id WPML
        $checkout_page_id_wpml = apply_filters( 'wpml_object_id', $checkout_page_id, 'product' );

        // Get redirect url
        $redirect_url = $checkout_page_id_wpml ? esc_url( get_permalink( $checkout_page_id_wpml ) ) : home_url();

        return apply_filters( 'ovaev_get_checkout_woo_page', $redirect_url );
    }
}

/**
 * Get cart woo page
 */
if ( !function_exists( 'ovaev_get_cart_woo_page' ) ) { 
    function ovaev_get_cart_woo_page() {
        // Get cart page id
        $cart_page_id = get_option( 'woocommerce_cart_page_id' );

        // Get cart page id WPML
        $cart_page_id_wpml = apply_filters( 'wpml_object_id', $cart_page_id, 'product' );

        // Get redirect url
        $redirect_url = $cart_page_id_wpml ? esc_url( get_permalink( $cart_page_id_wpml ) ) : home_url();

        return apply_filters( 'ovaev_get_cart_woo_page', $redirect_url );
    }
}

/**
 * Process checkout
 */
if ( !function_exists( 'ovaev_process_checkout' ) ) {  
    function ovaev_process_checkout( $post_data ) {
        if ( empty( $post_data ) ) $post_data = $_POST;
        
        // Get event id
        $event_id = ovaev_get_meta_data( 'ide', $post_data );
        if ( !$event_id ) return false;

        // Setup a session for cart
        OVAEV()->cart_session->remove();
        OVAEV()->cart_session->set( 'event_id', $event_id );

        // Payment
        $payment_woo    = new Ovaev_Payment_Woo();
        $results        = $payment_woo->process();

        if ( 'success' === ovaev_get_meta_data( 'status', $results ) ) {
            // Send Mail
            $data['el_url'] = $result['url'];

            echo json_encode( $data );
            exit();
        } else {
            return false;
        }

        return false;
    }
}

/**
 * Before calculate totals
 */
add_action( 'woocommerce_before_calculate_totals', function( $cart ) {
    if ( is_admin() && !defined( 'DOING_AJAX' ) ) return;
    if ( did_action( 'woocommerce_before_calculate_totals' ) >= 2 ) return;

    // Loop through cart items
    foreach ( $cart->get_cart() as $cart_item ) {
        // Get event id
        $event_id = ovaev_get_meta_data( 'event_id', $cart_item );
        if ( ! $event_id ) continue;

        // Get event post
        $event_obj = get_post( $event_id );

        // Get price
        $new_price = get_post_meta( $event_id, 'ovaev_price', true );

        // Get an instance of the WC_Product object
        $product = $cart_item['data'];

        // Get the product name (Added Woocommerce 3+ compatibility)
        $original_name = method_exists( $product, 'get_name' ) ? $product->get_name() : $product->post->post_title;

        // Set new name
        if ( is_object( $event_obj ) && isset( $event_obj->post_title ) ){
            $new_name = $event_obj->post_title;

            // Set the new name (WooCommerce versions 2.5.x to 3+)
            if ( method_exists( $product, 'set_name' ) ) {
                $product->set_name( $new_name );
            } else {
                $product->post->post_title = $new_name;
            }
        }

        // Set new price
        $cart_item['data']->set_price( $new_price );
    }
});

/**
 * Create order line item
 */
add_action( 'woocommerce_checkout_create_order_line_item', function( $item, $cart_item_key, $values, $order ) {
    // Get booking id in session
    if ( ovaev_get_meta_data( 'event_id', $values ) ) {
        // Add data event_id
        $item->add_meta_data( 'event_id', $values['event_id'] );
    }
}, 10, 4 );

/**
 * Cart item permalink
 */
add_filter( 'woocommerce_cart_item_permalink', function( $permalink, $cart_item, $cart_item_key ) {
    // Get product id
    $product_id = ovaev_get_meta_data( 'product_id', $cart_item );

    // Get event id
    $event_id = ovaev_get_meta_data( 'event_id', $cart_item );

    // Permalink
    $permalink = '#';

    if ( $event_id ) {
        $permalink  = get_permalink( $event_id );
    } else {
        $permalink  = get_permalink( $product_id );
    }

    return $permalink;
}, 10, 3 );

/**
 * Order item permalink
 */
add_filter( 'woocommerce_order_item_permalink' , function( $permalink, $item, $order ) {
    // Get product id
    $product_id = ovaev_get_meta_data( 'product_id', $item );

    // Get event id
    $event_id = ovaev_get_meta_data( 'event_id', $item );

    // Permalink
    $permalink = '#';

    if ( $event_id ) {
        $permalink  = get_permalink( $event_id );
    } else {
        $permalink  = get_permalink( $product_id );
    }

    return $permalink;
}, 10, 3 );

/**
 * Order item hide fields
 */
add_filter( 'woocommerce_order_item_get_formatted_meta_data', function( $meta_data, $item ) {
    $field_hide = [ 'event_id' ];
    $new_meta   = [];

    foreach ( $meta_data as $id => $meta_array ) {
        if ( in_array( $meta_array->key, $field_hide ) ) { continue; }
        $new_meta[$id] = $meta_array;
    }

    return $new_meta;
}, 10, 2 );