<?php if ( !defined( 'ABSPATH' ) ) { exit(); }

class Ovaev_Payment_Woo{

	protected static $_instance = null;

	public $id = 'woo';
	public $event_id = null;
	
	function __construct(){
		$this->_title = esc_html__( 'Woocommerce', 'ovaev' );

		$this->event_id = OVAEV()->cart_session->get( 'event_id' );

		if ( !empty($this->event_id) ) {
			// Add Extra Fields to cart
			add_filter( 'woocommerce_add_cart_item_data', array( $this, 'ovaev_add_extra_data_to_cart_item' ), 10, 4 );
		}

	}

	function process(){

		if ( class_exists( 'WooCommerce' ) ) { 
			WC()->cart->empty_cart();
		}

     	// a product to cart in woocommerce
		$product_id = OVAEV_Settings::ovaev_booking_via_woo(); //replace with your own product id
		$found = false;

     	//check if product already in cart
		if ( sizeof( WC()->cart->get_cart() ) > 0 ) {
			foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
				$_product = $values['data'];
				if ( $_product->get_id() == $product_id )
					$found = true;
			}
         	// if product not found, add it
			if ( ! $found )
				WC()->cart->add_to_cart( $product_id );
		} else {
         	// if no products in cart, add it
			WC()->cart->add_to_cart( $product_id );
		}

    	// Return about checkout page in woocommerce
		$checkout_page = ovaev_get_cart_woo_page();
		return array(
			'status'    => 'success',
			'url'       => $checkout_page
		);
	}

	function ovaev_add_extra_data_to_cart_item( $cart_item_data, $product_id, $variation_id, $quantity ) {
      	// Get booking id in session
		$event_id  = $this->event_id;

		// Add data event_id
		$cart_item_data['event_id'] = $event_id;

		return $cart_item_data;
	}

	public static function instance() {
		if ( !empty( self::$_instance ) ) {
			return self::$_instance;
		}
		return self::$_instance = new self();
	}

}