<?php
namespace ova_ovaev_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_event_countdown extends Widget_Base {

	public function get_name() {		
		return 'ova_event_countdown';
	}

	public function get_title() {
		return esc_html__( 'Event Countdown', 'ovaev' );
	}

	public function get_icon() {
		return 'eicon-counter-circle';
	}

	public function get_categories() {
		return [ 'ovaev_template' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'timeCircles', OVAEV_PLUGIN_URI. 'assets/libs/timecircles/timeCircles.js', [ 'jquery' ], false, true );
		wp_enqueue_style( 'timeCircles', OVAEV_PLUGIN_URI.'assets/libs/timecircles/timeCircles.css' );
		return [ 'script-elementor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_demo',
			[
				'label' => esc_html__( 'Demo', 'ova-brw' ),
			]
		);
			$default_event 	= '';
			$arr_event 		= array();

			$events = ovaev_get_all_events();
			if ( !empty( $events ) && is_array( $events ) ) {
				$default_event = $events[0];

				foreach( $events as $event_id ) {
					$arr_event[$event_id] = get_the_title( $event_id );
				}
			} else {
				$arr_event[''] = esc_html__( 'There are no events', 'ova-brw' );
			}

			$this->add_control(
				'event_id',
				[
					'label' 	=> esc_html__( 'Choose Event', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> $default_event,
					'options' 	=> $arr_event,
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ovaev' ),
			]
		);

			$this->add_control(
				'template',
				[
					'label' => esc_html__('Template','ovaev'),
					'type' 	=> Controls_Manager::SELECT,
					'default' => 'template1',
					'options' => [
						'template1' => esc_html__('Template 1', 'ovaev'),
						'template2' => esc_html__('Template 2', 'ovaev'),
 					],
				]
			);

			$this->add_control(
				'date_format',
				[
					'label' 	=> esc_html__( 'Date Format', 'ovaev' ),
					'type' 		=> Controls_Manager::SELECT,
					'options' 	=> [
						'd-m-Y'	=> 'd-m-Y',
						'Y-m-d'	=> 'Y-m-d',
						'm/d/Y'	=> 'm/d/Y',
						'Y/m/d'	=> 'Y/m/d',
						'd.m.Y'	=> 'd.m.Y',
						'Y.m.d'	=> 'Y.m.d',
					],
					'default' 	=> 'd.m.Y',
				]
			);

			$this->add_control(
				'heading',
				[
					'label' => esc_html__('Heading','ovaev'),
					'type' 	=> Controls_Manager::TEXT,
					'default' => esc_html__('Upcoming Event','ovaev'),
				]
			);

			$this->add_control(
				'text_button',
				[
					'label' => esc_html__('Text Button','ovaev'),
					'type' 	=> Controls_Manager::TEXT,
					'default' => esc_html__('Join Events','ovaev'),
				]
			);

			$this->add_control(
				'label_day',
				[
					'label' => esc_html__('Label Day','ovaev'),
					'type' 	=> Controls_Manager::TEXT,
					'default' => esc_html__('Days','ovaev'),
				]
			);

			$this->add_control(
				'label_hour',
				[
					'label' => esc_html__('Label Hour','ovaev'),
					'type' 	=> Controls_Manager::TEXT,
					'default' => esc_html__('Hours','ovaev'),
				]
			);

			$this->add_control(
				'label_minute',
				[
					'label' => esc_html__('Label Minute','ovaev'),
					'type' 	=> Controls_Manager::TEXT,
					'default' => esc_html__('Minutes','ovaev'),
				]
			);

			$this->add_control(
				'label_second',
				[
					'label' => esc_html__('Label Second','ovaev'),
					'type' 	=> Controls_Manager::TEXT,
					'default' => esc_html__('Seconds','ovaev'),
				]
			);


			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'background',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .ovaev-event-countdown .countdown-timer-container',
					'condition' => [
						'template' => 'template2'
					]
				]
			);

		$this->end_controls_section();

	}

	protected function render() {

		$settings 	= $this->get_settings();

		$template   = $settings['template'];
		$heading	= $settings['heading'];

		$text_button = $settings['text_button'];

		$label_day	= $settings['label_day'];
		$label_hour	= $settings['label_hour'];

		$label_minute	= $settings['label_minute'];
		$label_second	= $settings['label_second'];

		$id 		= get_the_ID();
		$post_type 	= get_post_type( $id );

		if ( empty( $post_type ) || 'event' != $post_type ) {
			$id = $settings['event_id'];
			$post_type 	= get_post_type( $id );
		}
		
		if ( empty( $post_type ) || 'event' != $post_type ) {
			echo '<div class="ovaev_elementor_none"><span>' . esc_html( $this->get_title() ) . '</span></div>';
			return;
		}

		$title = get_the_title($id);

		$ovaev_venue = get_post_meta( $id, 'ovaev_venue', true ); 

		// Start date
		$date_format      	= $settings['date_format'];
		$ovaev_start_date 	= get_post_meta( $id, 'ovaev_start_date_time', true );
		$start_date    		= $ovaev_start_date  != '' ? date_i18n($date_format, $ovaev_start_date) 	: '';
		$countdown_date    	= $ovaev_start_date  != '' ? date_i18n( 'Y-m-d h:m:s', $ovaev_start_date )  : '';

		?>
		
			<div class="ovaev-event-countdown <?php echo esc_attr($template);?>" 
				data-label_day="<?php echo esc_attr($label_day);?>"
				data-label_hour="<?php echo esc_attr($label_hour);?>"
				data-label_minute="<?php echo esc_attr($label_minute);?>"
				data-label_second="<?php echo esc_attr($label_second);?>"
			>

				<?php if(!empty($heading)) { ?>
					<h2 class="heading-event">
						<?php echo esc_html($heading); ?>
					</h2>
				<?php } ?>

				<div class="event-countdown">
					<h3 class="title">
			    		<?php echo esc_html($title);?>
			    	</h3>

                    <?php if( ! empty( $start_date ) ) { ?>
                        <div class="time equal-date">
                            <span class="icon-time">
                                <i class="flaticon flaticon-calendar icon_event"></i>
                            </span>
                            <span class="time-date-child">
                                <span class="date-child">
                                    <?php echo esc_html( $start_date ); ?>
                                </span>
                            </span>
                        </div>
                    <?php } ?>
                    <?php if( ! empty( $ovaev_venue ) ) { ?>
                        <div class="venue">
                            <i class="flaticon flaticon-home icon_event"></i>
                            <span class="number">
                                <?php echo esc_html( $ovaev_venue ); ?>
                            </span>
                        </div>
                    <?php } ?>
				</div>

				<div class="countdown-timer-container">
					<?php if( $template == 'template1') { ?>
						<div class="countdown-timer" data-date="<?php echo esc_attr($countdown_date);?>"></div>
					<?php } else { ?>
						<div class="countdown-timer-not-timecircles" data-date="<?php echo esc_attr($countdown_date);?>">
							<div class="timer-wrapper">
								<div class="timer" id="days"></div>
								<span class="label">
									<?php echo esc_html($label_day);?>
								</span>
							</div>
							<div class="timer-wrapper">
								<div class="timer" id="hours"></div>
								<span class="label">
									<?php echo esc_html($label_hour);?>
								</span>
							</div>
							<div class="timer-wrapper">
								<div class="timer" id="min"></div>
								<span class="label">
									<?php echo esc_html($label_minute);?>
								</span>
							</div>
							<div class="timer-wrapper">
								<div class="timer" id="sec"></div>
								<span class="label">
									<?php echo esc_html($label_second);?>
								</span>
							</div>
						</div>
					<?php } ?>

					<a href="<?php echo get_the_permalink( $id ) ?>" class="join-event">
						<span class="text-button"><?php echo esc_html($text_button); ?></span>
						<i aria-hidden="true" class="ovaicon ovaicon-next"></i>
					</a>
				</div>
			</div>
			
		<?php
	}
}
