<?php
namespace ova_ovaev_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_event_categories_slide extends Widget_Base {


	public function get_name() {		
		return 'ova_event_categories_slide';
	}

	public function get_title() {
		return esc_html__( 'Categories Slide', 'ovaev' );
	}

	public function get_icon() {
		return 'eicon-slider-album';
	}

	public function get_categories() {

		return [ 'ovatheme' ];
	}

	public function get_script_depends() {
		wp_enqueue_style( 'owl-carousel', OVAEV_PLUGIN_URI.'assets/libs/owl-carousel/assets/owl.carousel.min.css' );
		wp_enqueue_script( 'owl-carousel', OVAEV_PLUGIN_URI.'assets/libs/owl-carousel/owl.carousel.min.js', array('jquery'), false, true );
		return [ 'script-elementor' ];
	}

	protected function register_controls() {
		/**
		 * Content Tab
		*/
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ovaev' ),
				
			]
		);

			$args = array(
				'taxonomy' 	=> 'event_category',
				'orderby' 	=> 'name',
				'order' 	=> 'ASC'
			);
  
		  	$categories 		= get_categories( $args );
		  	$category_args 		= [];
		  	
		  	if ( ! empty( $categories ) && is_array( $categories ) ) {
			  	foreach ( $categories as $k => $category ) {
				  	$category_args[$category->term_id] = $category->name;
			  	}
		  	} else {
			  	$category_args[''] = esc_html__( 'Category not found', 'ovaev' );
		  	}

		  	$this->add_control(
				'categories',
				[
					'label' 		=> esc_html__( 'Select Categories', 'ovaev' ),
					'type' 			=> \Elementor\Controls_Manager::SELECT2,
					'label_block' 	=> true,
					'multiple' 		=> true,
					'options' 		=> $category_args,
					'default' 		=> '',
				]
			);

			$this->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' 	=> [
						'value' 	=> 'fas fa-arrow-right',
						'library' 	=> 'all',
					],
				]
			);

			$this->add_control(
				'label_view_details',
				[
					'label' => esc_html__( 'Text Button', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__('View detail', 'ovaev'),
				]
			);

		$this->end_controls_section(); // End Content Tab

		/*****************************************************************
						START SECTION ADDITIONAL
		******************************************************************/

		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'ovaev' ),
			]
		);


		/***************************  VERSION  ***********************/
			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'ovaev' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'ovaev' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'ovaev' ),
					'default'     => 3,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'ovaev' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ovaev' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'ovaev' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'ovaev' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'ovaev' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ovaev' ),
						'no'  => esc_html__( 'No', 'ovaev' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		/****************************  END SECTION ADDITIONAL *********************/

		//SECTION TAB STYLE CONTENT
		$this->start_controls_section(
			'section_content_item',
			[
				'label' => esc_html__( 'Content', 'ovaev' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			// General
			$this->add_responsive_control(
				'content_border_radius',
				[
					'label' 		=> esc_html__( 'Border Radius', 'ovaev' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'content_border_radius_hover',
				[
					'label' 		=> esc_html__( 'Border Radius Hover', 'ovaev' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ovaev-categories-slide .item:hover .image-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			// Title
			$this->add_control(
				'title_content',
				[
					'label' => esc_html__( 'Title', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

				$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
						'name' => 'title_typography',
						'selector' => '{{WRAPPER}} .ovaev-categories-slide .item .title a',
					]
				);

				$this->add_control(
					'color_title',
					[
						'label' => esc_html__( 'Color', 'ovaev' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ovaev-categories-slide .item .title a' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'color_title_hover',
					[
						'label' => esc_html__( 'Color Hover', 'ovaev' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ovaev-categories-slide .item .title a:hover' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_responsive_control(
					'margin_title',
					[
						'label' => esc_html__( 'Margin', 'ovaev' ),
						'type' => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors' => [
							'{{WRAPPER}} .ovaev-categories-slide .item .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

				$this->add_responsive_control(
					'title_alignment',
					[
						'label' 	=> esc_html__( 'Alignment', 'ovaev' ),
						'type' 		=> \Elementor\Controls_Manager::CHOOSE,
						'options' 	=> [
							'left' => [
								'title' => esc_html__( 'Left', 'ovaev' ),
								'icon' 	=> 'eicon-text-align-left',
							],
							'center' => [
								'title' => esc_html__( 'Center', 'ovaev' ),
								'icon' 	=> 'eicon-text-align-center',
							],
							'right' => [
								'title' => esc_html__( 'Right', 'ovaev' ),
								'icon' 	=> 'eicon-text-align-right',
							],
						],
						'toggle' 	=> true,
						'selectors' => [
							'{{WRAPPER}} .ovaev-categories-slide .item .title' => 'text-align: {{VALUE}}',
						],
					]
				);

			// Text Button (View Detail)
			$this->add_control(
				'view_detail',
				[
					'label' => esc_html__( 'Text Button', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

				$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
						'name' => 'view_detail_typography',
						'selector' => '{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail .read-more',
					]
				);

				$this->add_control(
					'color_view_detail',
					[
						'label' => esc_html__( 'Color', 'ovaev' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail .read-more' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'color_view_detail_hover',
					[
						'label' => esc_html__( 'Color Hover', 'ovaev' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail .read-more:hover' => 'color : {{VALUE}};',
						],
					]
				);

			// Icon Button (View Detail)
			$this->add_control(
				'icon_button',
				[
					'label' => esc_html__( 'Icon', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

				$this->add_responsive_control(
					'icon_size',
					[
						'label' 	=> esc_html__( 'Icon Size', 'ovaev' ),
						'type' 		=> Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 40,
							],
						],
						'size_units' 	=> [ 'px' ],
						'selectors' 	=> [
							'{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail .read-more i' => 'font-size: {{SIZE}}{{UNIT}};',
						],
					]
				);

				$this->add_responsive_control(
					'icon_rotate',
					[
						'label' => esc_html__( 'Rotate', 'ovaev' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'deg', 'grad', 'rad', 'turn', 'custom' ],
						'default' => [
							'unit' => 'deg',
						],
						'tablet_default' => [
							'unit' => 'deg',
						],
						'mobile_default' => [
							'unit' => 'deg',
						],
						'selectors' => [
							'{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail .read-more i, {{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail .read-more svg' => 'transform: rotate({{SIZE}}{{UNIT}});',
						],
					]
				);

			// Image
			$this->add_control(
				'image_heading',
				[
					'label' => esc_html__( 'Image', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

				$this->add_control(
					'overlay_bgcolor',
					[
						'label' => esc_html__( 'Overlay', 'ovaev' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail:before' => 'background-color : {{VALUE}};',
						],
					]
				);

				$this->add_responsive_control(
					'overlay_bgcolor_opacity',
					[
						'label' 	=> esc_html__( 'Opacity', 'ovaev' ),
						'type' 		=> Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 1,
							],
						],
						'step' => 0.1,
						'size_units' 	=> [ 'px' ],
						'selectors' 	=> [
							'{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail:before' => 'opacity: {{SIZE}};',
						],
					]
				);

				$this->add_responsive_control(
					'image_height',
					[
						'label' 	=> esc_html__( 'Height', 'ovaev' ),
						'type' 		=> Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'min' => 120,
								'max' => 330,
							],
						],
						'size_units' 	=> [ 'px' ],
						'selectors' 	=> [
							'{{WRAPPER}} .ovaev-categories-slide .item .image-thumbnail img' => 'height: {{SIZE}}{{UNIT}};min-height: {{SIZE}}{{UNIT}};',
						],
					]
				);


		$this->end_controls_section();
		//END SECTION TAB STYLE CONTENT
	}

	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'elementor_ovaev_categories_slide', 'elements/ovaev_categories_slide.php' );

		ob_start();
		ovaev_get_template( $template, $settings );
		echo ob_get_clean();

	}
}