(function($){
    "use strict";
	
	$(window).on('elementor/frontend/init', function () {
    
    /*Simple Calendar*/
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ova_events_simple_calendar.default', function() {
        $(document).ready(function() {
            var calendars = {};

            $('.ovaev_simple_calendar').each( function(e) {
                var thisMonth     = moment().format('YYYY-MM');
                var events        = $(this).attr('events');
                var daysOfTheWeek = $(this).data('days-of-the-week');

                if ( events && events.length > 0 ) {
                    events = JSON.parse( events );
                }

                // Events to load into calendar
                calendars.clndr1 = $(this).find('.ovaev_events_simple_calendar').clndr({
                    events: events,
                    daysOfTheWeek: daysOfTheWeek,
                    clickEvents: {
                        click: function (target) {
                            var eve =  target.events;
                            location.assign(eve[0].url);
                        },
                    },

                  multiDayEvents: {
                      singleDay: 'date',
                      endDate: 'endDate',
                      startDate: 'startDate'
                  },
                  showAdjacentMonths: true,
                  adjacentDaysChangeMonth: false
              
              });

               $(document).keydown( function(e) {
                  // Left arrow
                  if (e.keyCode == 37) {
                      calendars.clndr1.back();
                  }

                  // Right arrow
                  if (e.keyCode == 39) {
                      calendars.clndr1.forward();
                  }
              });

            });

          });
    });

    // Event slide
    elementorFrontend.hooks.addAction('frontend/element_ready/ova_events_slide.default', function(){
        $(".ovaev-slide").each(function(){
              var owlsl = $(this) ;
              var owlsl_ops = owlsl.data('options') ? owlsl.data('options') : {};
              if ( $('body').hasClass('rtl') ) {
                owlsl_ops.rtl = true;
              }

              var responsive_value = {
                  0:{
                    items:1,
                    nav:false
                  },
                  576:{
                    items:1
                  },
                  992:{
                    items:2,
                    nav:false
                  },
                  1170:{
                    items:owlsl_ops.items
                  }
              };
              
              owlsl.owlCarousel({
                autoWidth: owlsl_ops.autoWidth,
                margin: owlsl_ops.margin,
                items: owlsl_ops.items,
                loop: owlsl_ops.loop,
                autoplay: owlsl_ops.autoplay,
                autoplayTimeout: owlsl_ops.autoplayTimeout,
                center: owlsl_ops.center,
                nav: owlsl_ops.nav,
                dots: owlsl_ops.dots,
                thumbs: owlsl_ops.thumbs,
                autoplayHoverPause: owlsl_ops.autoplayHoverPause,
                slideBy: owlsl_ops.slideBy,
                smartSpeed: owlsl_ops.smartSpeed,
                rtl : owlsl_ops.rtl,
                navText:[
                '<i class="arrow_carrot-left" ></i>',
                '<i class="arrow_carrot-right" ></i>'
                ],
                responsive: responsive_value,
              });

            });
    });

    // Event Categories slide
    elementorFrontend.hooks.addAction('frontend/element_ready/ova_event_categories_slide.default', function(){
        $(".ovaev-categories-slide .categories-slide").each(function(){
              var owlsl = $(this) ;
              var owlsl_ops = owlsl.data('options') ? owlsl.data('options') : {};
              if ( $('body').hasClass('rtl') ) {
                owlsl_ops.rtl = true;
              }

              var responsive_value = {
                  0:{
                    items:1,
                    nav:false
                  },
                  600:{
                    items:2,
                  },
                  1170:{
                    items:owlsl_ops.items
                  }
              };
              
              owlsl.owlCarousel({
                autoWidth: owlsl_ops.autoWidth,
                margin: owlsl_ops.margin,
                items: owlsl_ops.items,
                loop: owlsl_ops.loop,
                autoplay: owlsl_ops.autoplay,
                autoplayTimeout: owlsl_ops.autoplayTimeout,
                center: owlsl_ops.center,
                nav: false,
                dots: owlsl_ops.dots,
                thumbs: owlsl_ops.thumbs,
                autoplayHoverPause: owlsl_ops.autoplayHoverPause,
                slideBy: owlsl_ops.slideBy,
                smartSpeed: owlsl_ops.smartSpeed,
                rtl : owlsl_ops.rtl,
                navText:[
                '<i class="arrow_carrot-left" ></i>',
                '<i class="arrow_carrot-right" ></i>'
                ],
                responsive: responsive_value,
              });

            });
    });

    // Event filter ajax
    elementorFrontend.hooks.addAction('frontend/element_ready/ova_events_ajax.default', function(){
        $(".ovapo_project_grid").each(function() {

          var slide = $(this).find('.grid');
          var data  = slide.data('owl');
          if ( slide.length > 0 ) {
            slide.owlCarousel(data);
          }

          $(this).find('.button-filter button:first-child').addClass('active');
          
          $(this).find('.button-filter').each(function() {

            var $ovapo_project_grid = $(this).closest('.ovapo_project_grid');

            $(this).on('click', 'button', function(e) {
              $(this).parent().find('.active').removeClass('active');
              $(this).addClass('active');

              e.preventDefault();
              var filter                = $(this).data('filter');
              var order                 = $(this).data('order');
              var orderby               = $(this).data('orderby');
              var number_post           = $(this).data('number_post');
              var layout                = $(this).data('layout');
              var first_term            = $(this).data('first_term');
              var term_id_filter_string = $(this).data('term_id_filter_string');
              var show_featured         = $(this).data('show_featured');

              $ovapo_project_grid.find('.wrap_loader').fadeIn(100);
            
              $.ajax({
                 url: ajax_object.ajax_url,
                 type: 'POST',
                 data: ({
                    action: 'filter_elementor_grid',
                    filter: filter,
                    order: order,
                    orderby: orderby,
                    number_post: number_post,
                    layout: layout,
                    first_term: first_term,
                    term_id_filter_string: term_id_filter_string,
                    show_featured: show_featured,
                 }),
                 success: function(response){

                    $ovapo_project_grid.find('.wrap_loader').fadeOut(200);

                    var items = $ovapo_project_grid.find('.items');
                    items.html( response ).fadeIn(300);
                    items.trigger('destroy.owl.carousel');
                    items.owlCarousel(data);
                 },
              })
            });
          });
        });
    });

    // Fullcalendar
    elementorFrontend.hooks.addAction('frontend/element_ready/ova_events_calendar.default', function(){
        $('.ovaev_fullcalendar').each( function( e){

          var events          = $(this).attr('full_events');
          var fullCalendar    = $(this).find('.ovaev_events_fullcalendar')[0];
          var lang            = $(this).data('lang');
          var button_text     = $(this).data('button-text');
          var no_events_text  = $(this).data('no-events-text');
          var all_day_text    = $(this).data('all-day-text');
          var first_day       = $(this).data('first-day');
          var default_view    = $(this).data('default-view');
          var calendar_view   = $(this).data('calendar-view');

          if( events && events.length > 0 ){
            events = JSON.parse( events );
          }

          //filter event
          var srcCalendar = new FullCalendar.Calendar(fullCalendar, {
          
            eventDidMount: function(info) {
              var tooltip = new Tooltip(info.el, {
                title: info.event.extendedProps.desc,
                placement: 'top',
                trigger: 'hover',
                container: 'body',
                html:true
              });
            },
            initialView: default_view,
            buttonText: button_text,
            noEventsText: no_events_text,
            allDayText: all_day_text,
            firstDay: first_day,
            locale: lang,
            timeZone: 'local',
            editable: true,
            navLinks: true,
            dayMaxEvents: true,
            events: events,
            eventColor: '#ff3514',
            contentHeight: 'auto',
            headerToolbar: {
               left: 'prev,next today',
               center: 'title',
               right: calendar_view,

            },
          });
          srcCalendar.render();

          //filter event
          var datetime = Date.now();
          var calendar_filter_event = $(this).find("#calendar_filter_event").val();

          var events_filter = [];
          $(this).find('#calendar_filter_event').on('change',function () {

            calendar_filter_event = $(this).val();
            srcCalendar.getEvents().forEach( event => event.remove() );

            if ( calendar_filter_event == 'all' ) {
              $.each( events, function( key, value ) {
                srcCalendar.addEvent(value);
              });
            } else if ( calendar_filter_event == 'past_event' ) {
              $.each( events, function( key, value ) {
                var end_date = new Date(value['end']).getTime();
                if ( end_date < datetime ) {
                  srcCalendar.addEvent(value);
                }
              });
            } else if ( calendar_filter_event == 'upcoming_event' ) {
              $.each( events, function( key, value ) {
                var start_date = new Date(value['start']).getTime();
                if ( start_date > datetime ) {
                  srcCalendar.addEvent(value);
                }
              });
            } else {
              $.each( events, function( key, value ) {
                var special = value['special'];
                if ( special == 'checked' ) {
                  srcCalendar.addEvent(value);
                }
              });
            }
          });
        });
    });

    // Event Search ajax
    elementorFrontend.hooks.addAction('frontend/element_ready/ova_events_search_ajax.default', function(){
        
        //Search Ajax
        $('.ovaev-wrapper-search-ajax').each( function(e){
          var that = $(this);

          var search_ajax = that.find('.search-ajax-content');
          var data_events = that.find('.data-events');
          var pagination  = that.find('.search-ajax-pagination-wrapper');
          var search_form = that.find('.ovaev-search-ajax-form');
          var select      = that.find('.ovaev_type');
          if ( select.length > 0 ) {
            select.select2();
          };

          // When form change
          search_form.on('change', function(e) {
            e.preventDefault();

            var form = $(this);

            var start_date  = form.find('input[name="ovaev_start_date_search"]').val();
            var end_date    = form.find('input[name="ovaev_end_date_search"]').val();
            var category    = form.find('select[name="ovaev_type"]').val();
            var layout      = data_events.data('layout');
            var column      = data_events.data('column');
            var per_page    = data_events.data('per-page');
            var order       = data_events.data('order');
            var orderby     = data_events.data('orderby');
            var cat_slug    = data_events.data('category-slug');
            var time_event  = data_events.data('time-event');

            that.find('.wrap_loader').fadeIn(100);

            $.ajax({
              url: ajax_object.ajax_url,
              type: 'POST',
              data: ({
                action: 'search_ajax_events',
                start_date: start_date,
                end_date  : end_date,
                category  : category,
                layout    : layout,
                column    : column,
                per_page  : per_page,
                order     : order,
                orderby   : orderby,
                cat_slug  : cat_slug,
                time_event: time_event,
              }),
              success: function(response){
                var data = JSON.parse(response);

                that.find('.wrap_loader').fadeOut(200);

                search_ajax.html('').append(data['result']).fadeIn(300);
                pagination.html('').append(data['pagination']).fadeIn(300);
              },
            });
          });

          // When click pagination
          $(document).on( 'click', '.ovaev-wrapper-search-ajax .search-ajax-pagination-wrapper .search-ajax-pagination .page-numbers', function(e) {
            e.preventDefault();

            var page = $(this);
            var that_page     = page.closest('.ovaev-wrapper-search-ajax');
            var current       = page.closest('.search-ajax-pagination').find('.current').data('paged');
            var current_page  = page.closest('.search-ajax-pagination').find('.current');
            var offset        = page.attr('data-paged');
            var total_page    = page.closest('.search-ajax-pagination').data('total-page');

            if ( offset != current ) {
              var start_date  = page.closest('.ovaev-wrapper-search-ajax').find('input[name="ovaev_start_date_search"]').val();
              var end_date    = page.closest('.ovaev-wrapper-search-ajax').find('input[name="ovaev_end_date_search"]').val();
              var category    = page.closest('.ovaev-wrapper-search-ajax').find('select[name="ovaev_type"]').val();
              var layout      = page.closest('.ovaev-wrapper-search-ajax').find('.data-events').data('layout');
              var column      = page.closest('.ovaev-wrapper-search-ajax').find('.data-events').data('column');
              var per_page    = page.closest('.ovaev-wrapper-search-ajax').find('.data-events').data('per-page');
              var order       = page.closest('.ovaev-wrapper-search-ajax').find('.data-events').data('order');
              var orderby     = page.closest('.ovaev-wrapper-search-ajax').find('.data-events').data('orderby');
              var cat_slug    = page.closest('.ovaev-wrapper-search-ajax').find('.data-events').data('category-slug');
              var time_event  = page.closest('.ovaev-wrapper-search-ajax').find('.data-events').data('time-event');

              that_page.find('.wrap_loader').fadeIn(100);

              $.ajax({
                url: ajax_object.ajax_url,
                type: 'POST',
                data: ({
                  action: 'search_ajax_events_pagination',
                  start_date: start_date,
                  end_date  : end_date,
                  category  : category,
                  layout    : layout,
                  column    : column,
                  per_page  : per_page,
                  order     : order,
                  orderby   : orderby,
                  cat_slug  : cat_slug,
                  time_event: time_event,
                  offset    : offset,
                }),
                success: function(response){
                  var data = JSON.parse(response);

                  that_page.find('.wrap_loader').fadeOut(200);
                  that_page.find('.search-ajax-content').html('').append(data['result']).fadeIn(300);

                  page.closest('.search-ajax-pagination').find('.page-numbers').removeClass('current');

                  if ( page.hasClass('next') ) {
                    current_page.closest('li').next().children('.page-numbers').addClass('current');
                  } else if ( page.hasClass('prev') ) {
                    current_page.closest('li').prev().children('.page-numbers').addClass('current');
                  } else {
                    page.addClass('current');
                  }

                  if ( parseInt(offset) > 1 ) {
                    page.closest('.search-ajax-pagination').find('.prev').attr('data-paged', parseInt(offset)-1);
                    page.closest('.search-ajax-pagination').find('.prev').css('display', 'inline-flex');
                  } else {
                    page.closest('.search-ajax-pagination').find('.prev').attr('data-paged', 0);
                    page.closest('.search-ajax-pagination').find('.prev').css('display', 'none');
                  }
                  
                  if ( parseInt(offset) == parseInt(total_page) ) {
                    page.closest('.search-ajax-pagination').find('.next').attr('data-paged', parseInt(offset));
                    page.closest('.search-ajax-pagination').find('.next').css('display', 'none');
                  } else {
                    page.closest('.search-ajax-pagination').find('.next').attr('data-paged', parseInt(offset)+1);
                    page.closest('.search-ajax-pagination').find('.next').css('display', 'inline-flex');
                  }
                },
              });
            }
          });
        });
    });

    // Event Countdown
    elementorFrontend.hooks.addAction('frontend/element_ready/ova_event_countdown.default', function(){
        $(".ovaev-event-countdown").each(function() {
          var that  = $(this);

          var label_day  = that.data('label_day');
          var label_hour = that.data('label_hour');
          var label_minute = that.data('label_minute');
          var label_second = that.data('label_second');

          var countdown  = that.find('.countdown-timer');
          countdown.TimeCircles({
            count_past_zero: false,
            text_size: 0.07,
            fg_width: 0.01,
            bg_width: 0.8,
            circle_bg_color: "#2D2F31",
            time: {
              Days: { show:true, text:label_day, color: "#00C4F4" },
              Hours: { show:true, text:label_hour, color: "#FF9700" },
              Minutes: { show:true, text:label_minute, color: "#D14D42" },
              Seconds: { show:true, text:label_second, color: "#12D176" }
            }
          });
          $(window).resize(function(){
              countdown.TimeCircles().rebuild();
          });

          // Template 2
          var countdown_not_timecircles  = that.find('.countdown-timer-not-timecircles');
          var futureDate = new Date(countdown_not_timecircles.data('date'));
          var daysItem   = countdown_not_timecircles.find('#days');
          var hoursItem  = countdown_not_timecircles.find("#hours");
          var minItem    = countdown_not_timecircles.find("#min");
          var secItem    = countdown_not_timecircles.find("#sec");

          var countDown = () => {
            var currentDate = new Date();
            var myDate = futureDate - currentDate;

            var days = Math.max(0, Math.floor(myDate / 1000 / 60 / 60 / 24) );

            var hours = Math.max(0, Math.floor(myDate / 1000 / 60 / 60) ) % 24;

            var min = Math.max(0, Math.floor(myDate / 1000 / 60) ) % 60;

            var sec = Math.max(0, Math.floor(myDate / 1000) ) % 60;

            daysItem.text(days);
            hoursItem.text(hours);
            minItem.text(min);
            secItem.text(sec);
          }

          countDown();

          setInterval(countDown, 1000);
        });
    });

   });
})(jQuery);