<?php if ( ! defined( 'ABSPATH' ) ) exit();

if ( ! class_exists( 'OVAEV_metaboxes' ) ) {
	class OVAEV_metaboxes {

		public function __construct() {
			$this->require_metabox();

			add_action( 'add_meta_boxes', array( $this , 'OVAEV_add_metabox' ) );
			add_action( 'save_post', array( $this , 'OVAEV_save_metabox' ) );

			// Save
			add_action( 'ovaev_update_meta_event', array( 'OVAEV_metaboxes_render_event' ,'save' ), 10, 2 );

			// Category
			add_action( 'event_category_add_form_fields', array( $this, 'OVAEV_taxonomy_add_new_meta_field' ) );
			add_action( 'event_category_edit_form_fields', array( $this, 'OVAEV_taxonomy_edit_meta_field' ) );
			add_action( 'edited_event_category', array( $this, 'OVAEV_taxonomy_save_meta_field' ) );
			add_action( 'create_event_category', array( $this, 'OVAEV_taxonomy_save_meta_field' ) );
		}

		public function require_metabox() {
			require_once( OVAEV_PLUGIN_PATH.'admin/meta-boxes/ovaev-metaboxes-event.php' );
		}

		public function OVAEV_add_metabox() {
			add_meta_box( 'ovaev-metabox-settings-event',
				'Events',
				array('OVAEV_metaboxes_render_event', 'render'),
				'event',
				'normal',
				'high'
			);
		}

		public function OVAEV_save_metabox( $post_id ) {
			// Bail if we're doing an auto save
			if ( empty( $_POST ) && defined( 'DOING_AJAX' ) && DOING_AJAX ) return;

			// if our nonce isn't there, or we can't verify it, bail
			if ( ! isset( $_POST['ovaev_nonce'] ) || !wp_verify_nonce( $_POST['ovaev_nonce'], 'ovaev_nonce' ) ) return;

			do_action( 'ovaev_update_meta_event', $post_id, $_POST );
		}

		public function OVAEV_taxonomy_add_new_meta_field( $array ) {
			?>
			<div class="form-field ovaev-icon-class-wrap">
				<label for="ovaev-icon-class"><?php esc_html_e( 'Icon Class', 'ovaev' ); ?></label>
				<input name="ovaev_icon_class" id="ovaev-icon-class" type="text" value="" size="40" aria-describedby="icon-class-description">
				<p class="description" id="icon-class-description"><?php esc_html_e( 'Applies to [ovaev_event_filter] shortcode', 'ovaev' ); ?></p>
			</div>
			<div class="form-field ovaev-image-class-wrap term-thumbnail-wrap">
				<label><?php esc_html_e( 'Thumbnail', 'ovaev' ); ?></label>
				<div id="event_cat_thumbnail" style="float: left; margin-right: 10px;"><img src="<?php echo OVAEV_PLUGIN_URI . 'assets/img/woocommerce-placeholder-100x100.png'; ?>" width="60px" height="60px" style="object-fit: cover;"></div>
				<div style="line-height: 60px;">
					<input type="hidden" id="event_cat_thumbnail_id" name="event_cat_thumbnail_id">
					<button type="button" class="upload_image_button button"><?php esc_html_e( 'Upload/Add image', 'ovaev' ); ?></button>
					<button type="button" class="remove_image_button button" style="display: none;"><?php esc_html_e( 'Remove image', 'ovaev' ); ?></button>
				</div>
				<script type="text/javascript">

					// Only show the "remove image" button when needed
					if ( ! jQuery( '#event_cat_thumbnail_id' ).val() ) {
						jQuery( '.remove_image_button' ).hide();
					}

					// Uploading files
					var file_frame;

					jQuery( document ).on( 'click', '.upload_image_button', function( event ) {

						event.preventDefault();

						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}

						// Create the media frame.
						file_frame = wp.media.frames.downloadable_file = wp.media({
							title: 'Choose an image',
							button: {
								text: 'Use image'
							},
							multiple: false
						});

						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							var attachment           = file_frame.state().get( 'selection' ).first().toJSON();
							var attachment_thumbnail = attachment.sizes.thumbnail || attachment.sizes.full;

							jQuery( '#event_cat_thumbnail_id' ).val( attachment.id );
							jQuery( '#event_cat_thumbnail' ).find( 'img' ).attr( 'src', attachment_thumbnail.url );
							jQuery( '.remove_image_button' ).show();
						});

						// Finally, open the modal.
						file_frame.open();
					});

					jQuery( document ).on( 'click', '.remove_image_button', function() {
						jQuery( '#event_cat_thumbnail' ).find( 'img' ).attr( 'src', '' );
						jQuery( '#event_cat_thumbnail_id' ).val( '' );
						jQuery( '.remove_image_button' ).hide();
						return false;
					});

					jQuery( document ).ajaxComplete( function( event, request, options ) {
						if ( request && 4 === request.readyState && 200 === request.status
							&& options.data && 0 <= options.data.indexOf( 'action=add-tag' ) ) {

							var res = wpAjax.parseAjaxResponse( request.responseXML, 'ajax-response' );
							if ( ! res || res.errors ) {
								return;
							}
							// Clear Thumbnail fields on submit
							jQuery( '#event_cat_thumbnail' ).find( 'img' ).attr( 'src', '' );
							jQuery( '#event_cat_thumbnail_id' ).val( '' );
							jQuery( '.remove_image_button' ).hide();
							// Clear Display type field on submit
							jQuery( '#display_type' ).val( '' );
							return;
						}
					} );

				</script>
				<div class="clear"></div>
			</div>
			<?php
		}

		public function OVAEV_taxonomy_edit_meta_field( $term ) {
			$term_id = $term->term_id;
			$placeholder_image_url = OVAEV_PLUGIN_URI . 'assets/img/woocommerce-placeholder-100x100.png';

			$icon_class  = get_term_meta( $term_id, 'ovaev_icon_class', true );
			$event_cat_thumbnail_id = get_term_meta( $term_id, 'event_cat_thumbnail_id', true );

			$image_url = wp_get_attachment_image_url( $event_cat_thumbnail_id, 'thumbnail' );
			if ( !$image_url ) {
				$image_url = $placeholder_image_url;
			}

			?>
			<tr class="form-field ovaev-icon-class-wrap">
				<th scope="row"><label for="ovaev-icon-class"><?php esc_html_e( 'Icon Class', 'ovaev' ); ?></label></th>
				<td>
					<input name="ovaev_icon_class" id="ovaev-icon-class" type="text" value="<?php echo esc_attr( $icon_class ); ?>" size="40" aria-describedby="icon-class-description">
					<p class="description" id="icon-class-description"><?php esc_html_e( 'Applies to [ovaev_event_filter] shortcode', 'ovaev' ); ?></p>
				</td>
			</tr>
			<tr class="form-field ovaev-image-class-wrap term-thumbnail-wrap">
				<th scope="row" valign="top"><label><?php esc_html_e( 'Thumbnail', 'ovaev' ); ?></label></th>
				<td>
					<div id="event_cat_thumbnail" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( $image_url ); ?>" width="60px" height="60px" style="object-fit: cover;"></div>
					<div style="line-height: 60px;">
						<input type="hidden" id="event_cat_thumbnail_id" name="event_cat_thumbnail_id" value="<?php echo esc_attr( $event_cat_thumbnail_id ); ?>">
						<button type="button" class="upload_image_button button"><?php esc_html_e( 'Upload/Add image', 'ovaev' ); ?></button>
						<button type="button" class="remove_image_button button" style="display: none;"><?php esc_html_e( 'Remove image', 'ovaev' ); ?></button>
					</div>
					<script type="text/javascript">

						// Only show the "remove image" button when needed
						if ( '0' === jQuery( '#event_cat_thumbnail_id' ).val() ) {
							jQuery( '.remove_image_button' ).hide();
						}

						// Uploading files
						var file_frame;

						jQuery( document ).on( 'click', '.upload_image_button', function( event ) {

							event.preventDefault();

							// If the media frame already exists, reopen it.
							if ( file_frame ) {
								file_frame.open();
								return;
							}

							// Create the media frame.
							file_frame = wp.media.frames.downloadable_file = wp.media({
								title: 'Choose an image',
								button: {
									text: 'Use image'
								},
								multiple: false
							});

							// When an image is selected, run a callback.
							file_frame.on( 'select', function() {
								var attachment           = file_frame.state().get( 'selection' ).first().toJSON();
								var attachment_thumbnail = attachment.sizes.thumbnail || attachment.sizes.full;

								jQuery( '#event_cat_thumbnail_id' ).val( attachment.id );
								jQuery( '#event_cat_thumbnail' ).find( 'img' ).attr( 'src', attachment_thumbnail.url );
								jQuery( '.remove_image_button' ).show();
							});

							// Finally, open the modal.
							file_frame.open();
						});

						jQuery( document ).on( 'click', '.remove_image_button', function() {
							jQuery( '#event_cat_thumbnail' ).find( 'img' ).attr( 'src', '' );
							jQuery( '#event_cat_thumbnail_id' ).val( '' );
							jQuery( '.remove_image_button' ).hide();
							return false;
						});

					</script>
					<div class="clear"></div>
				</td>
			</tr>
			<?php
		}

		public function OVAEV_taxonomy_save_meta_field( $term_id ) {
			$icon_class  = isset( $_REQUEST['ovaev_icon_class'] ) ? $_REQUEST['ovaev_icon_class'] : '';
			$event_cat_thumbnail_id = isset( $_REQUEST['event_cat_thumbnail_id'] ) ? $_REQUEST['event_cat_thumbnail_id'] : '';

    		update_term_meta( $term_id, 'ovaev_icon_class', $icon_class );
    		update_term_meta( $term_id, 'event_cat_thumbnail_id', $event_cat_thumbnail_id );
		}
	}

	new OVAEV_metaboxes();
}

?>