<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Give\Helpers\Form\Utils as FormUtils;

use Give\Controller\Form as Form;

class Humani_Give {

    public function __construct() {

        add_action('give_forms_category_add_form_fields', [$this, 'add_term_fields_color']);
        add_action('give_forms_category_edit_form_fields', [$this, 'edit_term_fields'], 10, 2);
        add_action('created_give_forms_category', [$this, 'save_term_fields']);
        add_action('edited_give_forms_category', [$this, 'save_term_fields']);

        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_script']);
        add_action('wp_enqueue_scripts', [$this, 'add_scripts'], 15);

        add_filter('give-settings_get_settings_pages', [$this, 'give_settings_page_pages'], 0, 1);
        add_filter('give_forms_single_sidebar', 'humani_give_sidebar', 10, 1);

        $this->give_hooks_single();

        add_action('give_before_single_form_summary', [$this, 'handleSingleDonationFormPage'], 10);

        add_action('give_embed_head', [$this, 'humani_give_embed_head']);

    }

    public function humani_give_embed_head() {
        global $humani_version;
        wp_enqueue_style('humani-give-embed', get_template_directory_uri() . '/assets/css/base/give-embed.css', '', $humani_version);
        if (humani_is_elementor_activated()) {
            $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
            Elementor\Plugin::$instance->kits_manager->frontend_before_enqueue_styles();
            $myvals = get_post_meta($active_kit_id, '_elementor_page_settings', true);
            if (!empty($myvals)) {
                $css = '';
                $css .= $myvals['system_colors'][0]['color'] !== '' ? '--give-donor-dashboard-accent-color:' . $myvals['system_colors'][0]['color'] . ';' : '';
                $var = "body{{$css}}";
                wp_add_inline_style('humani-give-embed', $var);
            }
        }

    }

    public function give_hooks_single() {

        add_action('give_single_form_summary', 'humani_give_meta', 5);
        add_action('give_single_form_summary', 'humani_single_give_content_start', 6);
        add_action('give_single_form_summary', 'give_show_form_images', 6);
        add_action('give_single_form_summary', 'humani_single_give_content_end', 190);
        add_action('give_single_form_summary', 'humani_single_give_summary_tab', 200);
        remove_action('give_pre_form_output', 'give_form_content', 10);
    }

    public function handleSingleDonationFormPage() {

        if (!FormUtils::isLegacyForm()) {
            add_action('humani_give_single_form_summary', 'give_template_single_title', 4);
            add_action('humani_give_single_form_summary', 'humani_give_meta', 5);
            add_action('humani_give_single_form_summary', 'give_show_form_images', 6);
            add_action('humani_give_single_form_summary', 'humani_single_give_summary_tab', 99);
            $form = new Form();
            add_action('give_after_single_form_summary', [$form, 'renderFormOnSingleDonationFormPage'], 1);
        }
    }

    public function give_settings_page_pages($settings) {
        include GIVE_PLUGIN_DIR . 'includes/admin/abstract-admin-settings-page.php';

        $settings[] = include get_theme_file_path('inc/give/class-give-setting.php');

        // Output.
        return $settings;
    }

    public function add_scripts() {
        global $humani_version;

        wp_register_script('humani-processbar', get_template_directory_uri() . '/assets/js/give/progressbar.js', array('jquery'), $humani_version, true);
        wp_enqueue_script('humani-give-main', get_template_directory_uri() . '/assets/js/give/main.js', array('jquery'), $humani_version, true);

        wp_enqueue_style('humani-give', get_template_directory_uri() . '/assets/css/base/give.css', '', $humani_version);
        wp_style_add_data('humani-give', 'rtl', 'replace');
    }

    public function save_term_fields($term_id) {

        update_term_meta(
            $term_id,
            '_color',
            sanitize_text_field($_POST['_color'])
        );

    }

    public function edit_term_fields($term, $taxonomy) {

        $value = get_term_meta($term->term_id, '_color', true);

        ?>
        <tr class="form-field">
            <th>
                <label for="category-color"><?php echo esc_html__('Color', 'humani'); ?></label>
            </th>
            <td>
                <input name="_color" id="category-color" class="color-picker" type="text" value="<?php echo esc_attr($value); ?>"/>
            </td>
        </tr>
        <?php

    }

    public function add_term_fields_color($taxonomy) {

        ?>
        <div class="form-field">
            <label for="category-color"><?php echo esc_html__('Color', 'humani'); ?></label>
            <input type="text" name="_color" class="color-picker" id="category-color"/>
        </div>
        <?php
    }

    public function enqueue_admin_script() {
        global $humani_version;

        $screen = get_current_screen();
        if ($screen->taxonomy == 'give_forms_category') {
            wp_enqueue_script('custtom-color-picker', get_theme_file_uri('assets/js/admin/colorpicker.js'), array(), $humani_version, true);

        }

    }

}

return new Humani_Give();