<?php

use Elementor\Controls_Manager;

add_action( 'elementor/element/image-box/section_image/before_section_end', function ($element, $args ) {
	$element->add_control(
		'image_style',
		[
			'label'   => esc_html__( 'Style', 'humani' ),
			'type'    => Controls_Manager::SELECT,
			'default'   => 'style-1',
			'options' => [
				'style-1'       => esc_html__( 'Style 1', 'humani' ),
				'style-2'       => esc_html__( 'Style 2', 'humani' ),
			],
			'prefix_class' => 'humani-image-box-',
		]
	);
}, 10, 2 );

add_action('elementor/element/image-box/section_style_content/before_section_end', function ($element, $args) {
    $element->add_responsive_control(
        'content_padding',
        [
            'type'      => \Elementor\Controls_Manager::DIMENSIONS,
            'label'     => esc_html__('Padding Content', 'humani'),
            'selectors' => [
                '{{WRAPPER}} .elementor-image-box-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
}, 10, 2 );
