<?php
/**
 * Insight
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * Insight Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Insight implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Insight';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'total_watch_time' => 'int',
        'total_playing_time' => 'int',
        'total_views' => 'int',
        'negative_impact_score' => 'float',
        'metric' => 'double',
        'filter_value' => 'string',
        'filter_column' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'total_watch_time' => 'int64',
        'total_playing_time' => 'int64',
        'total_views' => 'int64',
        'negative_impact_score' => 'float',
        'metric' => 'double',
        'filter_value' => null,
        'filter_column' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'total_watch_time' => true,
        'total_playing_time' => true,
        'total_views' => false,
        'negative_impact_score' => false,
        'metric' => false,
        'filter_value' => true,
        'filter_column' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'total_watch_time' => 'total_watch_time',
        'total_playing_time' => 'total_playing_time',
        'total_views' => 'total_views',
        'negative_impact_score' => 'negative_impact_score',
        'metric' => 'metric',
        'filter_value' => 'filter_value',
        'filter_column' => 'filter_column'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'total_watch_time' => 'setTotalWatchTime',
        'total_playing_time' => 'setTotalPlayingTime',
        'total_views' => 'setTotalViews',
        'negative_impact_score' => 'setNegativeImpactScore',
        'metric' => 'setMetric',
        'filter_value' => 'setFilterValue',
        'filter_column' => 'setFilterColumn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'total_watch_time' => 'getTotalWatchTime',
        'total_playing_time' => 'getTotalPlayingTime',
        'total_views' => 'getTotalViews',
        'negative_impact_score' => 'getNegativeImpactScore',
        'metric' => 'getMetric',
        'filter_value' => 'getFilterValue',
        'filter_column' => 'getFilterColumn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('total_watch_time', $data ?? [], null);
        $this->setIfExists('total_playing_time', $data ?? [], null);
        $this->setIfExists('total_views', $data ?? [], null);
        $this->setIfExists('negative_impact_score', $data ?? [], null);
        $this->setIfExists('metric', $data ?? [], null);
        $this->setIfExists('filter_value', $data ?? [], null);
        $this->setIfExists('filter_column', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets total_watch_time
     *
     * @return int|null
     */
    public function getTotalWatchTime()
    {
        return $this->container['total_watch_time'];
    }

    /**
     * Sets total_watch_time
     *
     * @param int|null $total_watch_time total_watch_time
     *
     * @return self
     */
    public function setTotalWatchTime($total_watch_time)
    {

        if (is_null($total_watch_time)) {
            array_push($this->openAPINullablesSetToNull, 'total_watch_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('total_watch_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['total_watch_time'] = $total_watch_time;

        return $this;
    }

    /**
     * Gets total_playing_time
     *
     * @return int|null
     */
    public function getTotalPlayingTime()
    {
        return $this->container['total_playing_time'];
    }

    /**
     * Sets total_playing_time
     *
     * @param int|null $total_playing_time total_playing_time
     *
     * @return self
     */
    public function setTotalPlayingTime($total_playing_time)
    {

        if (is_null($total_playing_time)) {
            array_push($this->openAPINullablesSetToNull, 'total_playing_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('total_playing_time', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['total_playing_time'] = $total_playing_time;

        return $this;
    }

    /**
     * Gets total_views
     *
     * @return int|null
     */
    public function getTotalViews()
    {
        return $this->container['total_views'];
    }

    /**
     * Sets total_views
     *
     * @param int|null $total_views total_views
     *
     * @return self
     */
    public function setTotalViews($total_views)
    {

        if (is_null($total_views)) {
            throw new \InvalidArgumentException('non-nullable total_views cannot be null');
        }

        $this->container['total_views'] = $total_views;

        return $this;
    }

    /**
     * Gets negative_impact_score
     *
     * @return float|null
     */
    public function getNegativeImpactScore()
    {
        return $this->container['negative_impact_score'];
    }

    /**
     * Sets negative_impact_score
     *
     * @param float|null $negative_impact_score negative_impact_score
     *
     * @return self
     */
    public function setNegativeImpactScore($negative_impact_score)
    {

        if (is_null($negative_impact_score)) {
            throw new \InvalidArgumentException('non-nullable negative_impact_score cannot be null');
        }

        $this->container['negative_impact_score'] = $negative_impact_score;

        return $this;
    }

    /**
     * Gets metric
     *
     * @return double|null
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     *
     * @param double|null $metric metric
     *
     * @return self
     */
    public function setMetric($metric)
    {

        if (is_null($metric)) {
            throw new \InvalidArgumentException('non-nullable metric cannot be null');
        }

        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets filter_value
     *
     * @return string|null
     */
    public function getFilterValue()
    {
        return $this->container['filter_value'];
    }

    /**
     * Sets filter_value
     *
     * @param string|null $filter_value filter_value
     *
     * @return self
     */
    public function setFilterValue($filter_value)
    {

        if (is_null($filter_value)) {
            array_push($this->openAPINullablesSetToNull, 'filter_value');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('filter_value', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['filter_value'] = $filter_value;

        return $this;
    }

    /**
     * Gets filter_column
     *
     * @return string|null
     */
    public function getFilterColumn()
    {
        return $this->container['filter_column'];
    }

    /**
     * Sets filter_column
     *
     * @param string|null $filter_column filter_column
     *
     * @return self
     */
    public function setFilterColumn($filter_column)
    {

        if (is_null($filter_column)) {
            throw new \InvalidArgumentException('non-nullable filter_column cannot be null');
        }

        $this->container['filter_column'] = $filter_column;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


