<?php
/**
 * AssetNonStandardInputReasons
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * AssetNonStandardInputReasons Class Doc Comment
 *
 * @category Class
 * @description An object containing one or more reasons the input file is non-standard. See [the guide on minimizing processing time](https://docs.mux.com/guides/minimize-processing-time) for more information on what a standard input is defined as. This object only exists on on-demand assets that have non-standard inputs, so if missing you can assume the input qualifies as standard.
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class AssetNonStandardInputReasons implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Asset_non_standard_input_reasons';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'video_codec' => 'string',
        'audio_codec' => 'string',
        'video_gop_size' => 'string',
        'video_frame_rate' => 'string',
        'video_resolution' => 'string',
        'video_bitrate' => 'string',
        'pixel_aspect_ratio' => 'string',
        'video_edit_list' => 'string',
        'audio_edit_list' => 'string',
        'unexpected_media_file_parameters' => 'string',
        'unsupported_pixel_format' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'video_codec' => null,
        'audio_codec' => null,
        'video_gop_size' => null,
        'video_frame_rate' => null,
        'video_resolution' => null,
        'video_bitrate' => null,
        'pixel_aspect_ratio' => null,
        'video_edit_list' => null,
        'audio_edit_list' => null,
        'unexpected_media_file_parameters' => null,
        'unsupported_pixel_format' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'video_codec' => false,
        'audio_codec' => false,
        'video_gop_size' => false,
        'video_frame_rate' => false,
        'video_resolution' => false,
        'video_bitrate' => false,
        'pixel_aspect_ratio' => false,
        'video_edit_list' => false,
        'audio_edit_list' => false,
        'unexpected_media_file_parameters' => false,
        'unsupported_pixel_format' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'video_codec' => 'video_codec',
        'audio_codec' => 'audio_codec',
        'video_gop_size' => 'video_gop_size',
        'video_frame_rate' => 'video_frame_rate',
        'video_resolution' => 'video_resolution',
        'video_bitrate' => 'video_bitrate',
        'pixel_aspect_ratio' => 'pixel_aspect_ratio',
        'video_edit_list' => 'video_edit_list',
        'audio_edit_list' => 'audio_edit_list',
        'unexpected_media_file_parameters' => 'unexpected_media_file_parameters',
        'unsupported_pixel_format' => 'unsupported_pixel_format'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'video_codec' => 'setVideoCodec',
        'audio_codec' => 'setAudioCodec',
        'video_gop_size' => 'setVideoGopSize',
        'video_frame_rate' => 'setVideoFrameRate',
        'video_resolution' => 'setVideoResolution',
        'video_bitrate' => 'setVideoBitrate',
        'pixel_aspect_ratio' => 'setPixelAspectRatio',
        'video_edit_list' => 'setVideoEditList',
        'audio_edit_list' => 'setAudioEditList',
        'unexpected_media_file_parameters' => 'setUnexpectedMediaFileParameters',
        'unsupported_pixel_format' => 'setUnsupportedPixelFormat'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'video_codec' => 'getVideoCodec',
        'audio_codec' => 'getAudioCodec',
        'video_gop_size' => 'getVideoGopSize',
        'video_frame_rate' => 'getVideoFrameRate',
        'video_resolution' => 'getVideoResolution',
        'video_bitrate' => 'getVideoBitrate',
        'pixel_aspect_ratio' => 'getPixelAspectRatio',
        'video_edit_list' => 'getVideoEditList',
        'audio_edit_list' => 'getAudioEditList',
        'unexpected_media_file_parameters' => 'getUnexpectedMediaFileParameters',
        'unsupported_pixel_format' => 'getUnsupportedPixelFormat'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const VIDEO_GOP_SIZE_HIGH = 'high';
    public const VIDEO_BITRATE_HIGH = 'high';
    public const VIDEO_EDIT_LIST_NON_STANDARD = 'non-standard';
    public const AUDIO_EDIT_LIST_NON_STANDARD = 'non-standard';
    public const UNEXPECTED_MEDIA_FILE_PARAMETERS_NON_STANDARD = 'non-standard';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getVideoGopSizeAllowableValues()
    {
        return [
            self::VIDEO_GOP_SIZE_HIGH,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getVideoBitrateAllowableValues()
    {
        return [
            self::VIDEO_BITRATE_HIGH,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getVideoEditListAllowableValues()
    {
        return [
            self::VIDEO_EDIT_LIST_NON_STANDARD,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAudioEditListAllowableValues()
    {
        return [
            self::AUDIO_EDIT_LIST_NON_STANDARD,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getUnexpectedMediaFileParametersAllowableValues()
    {
        return [
            self::UNEXPECTED_MEDIA_FILE_PARAMETERS_NON_STANDARD,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('video_codec', $data ?? [], null);
        $this->setIfExists('audio_codec', $data ?? [], null);
        $this->setIfExists('video_gop_size', $data ?? [], null);
        $this->setIfExists('video_frame_rate', $data ?? [], null);
        $this->setIfExists('video_resolution', $data ?? [], null);
        $this->setIfExists('video_bitrate', $data ?? [], null);
        $this->setIfExists('pixel_aspect_ratio', $data ?? [], null);
        $this->setIfExists('video_edit_list', $data ?? [], null);
        $this->setIfExists('audio_edit_list', $data ?? [], null);
        $this->setIfExists('unexpected_media_file_parameters', $data ?? [], null);
        $this->setIfExists('unsupported_pixel_format', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getVideoGopSizeAllowableValues();
        if (!is_null($this->container['video_gop_size']) && !in_array($this->container['video_gop_size'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'video_gop_size', must be one of '%s'",
                $this->container['video_gop_size'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getVideoBitrateAllowableValues();
        if (!is_null($this->container['video_bitrate']) && !in_array($this->container['video_bitrate'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'video_bitrate', must be one of '%s'",
                $this->container['video_bitrate'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getVideoEditListAllowableValues();
        if (!is_null($this->container['video_edit_list']) && !in_array($this->container['video_edit_list'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'video_edit_list', must be one of '%s'",
                $this->container['video_edit_list'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAudioEditListAllowableValues();
        if (!is_null($this->container['audio_edit_list']) && !in_array($this->container['audio_edit_list'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'audio_edit_list', must be one of '%s'",
                $this->container['audio_edit_list'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getUnexpectedMediaFileParametersAllowableValues();
        if (!is_null($this->container['unexpected_media_file_parameters']) && !in_array($this->container['unexpected_media_file_parameters'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'unexpected_media_file_parameters', must be one of '%s'",
                $this->container['unexpected_media_file_parameters'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets video_codec
     *
     * @return string|null
     */
    public function getVideoCodec()
    {
        return $this->container['video_codec'];
    }

    /**
     * Sets video_codec
     *
     * @param string|null $video_codec The video codec used on the input file. For example, the input file encoded with `hevc` video codec is non-standard and the value of this parameter is `hevc`.
     *
     * @return self
     */
    public function setVideoCodec($video_codec)
    {

        if (is_null($video_codec)) {
            throw new \InvalidArgumentException('non-nullable video_codec cannot be null');
        }

        $this->container['video_codec'] = $video_codec;

        return $this;
    }

    /**
     * Gets audio_codec
     *
     * @return string|null
     */
    public function getAudioCodec()
    {
        return $this->container['audio_codec'];
    }

    /**
     * Sets audio_codec
     *
     * @param string|null $audio_codec The audio codec used on the input file. Non-AAC audio codecs are non-standard.
     *
     * @return self
     */
    public function setAudioCodec($audio_codec)
    {

        if (is_null($audio_codec)) {
            throw new \InvalidArgumentException('non-nullable audio_codec cannot be null');
        }

        $this->container['audio_codec'] = $audio_codec;

        return $this;
    }

    /**
     * Gets video_gop_size
     *
     * @return string|null
     */
    public function getVideoGopSize()
    {
        return $this->container['video_gop_size'];
    }

    /**
     * Sets video_gop_size
     *
     * @param string|null $video_gop_size The video key frame Interval (also called as Group of Picture or GOP) of the input file is `high`. This parameter is present when the gop is greater than 20 seconds.
     *
     * @return self
     */
    public function setVideoGopSize($video_gop_size)
    {
        $allowedValues = $this->getVideoGopSizeAllowableValues();
        if (!is_null($video_gop_size) && !in_array($video_gop_size, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'video_gop_size', must be one of '%s'",
                    $video_gop_size,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($video_gop_size)) {
            throw new \InvalidArgumentException('non-nullable video_gop_size cannot be null');
        }

        $this->container['video_gop_size'] = $video_gop_size;

        return $this;
    }

    /**
     * Gets video_frame_rate
     *
     * @return string|null
     */
    public function getVideoFrameRate()
    {
        return $this->container['video_frame_rate'];
    }

    /**
     * Sets video_frame_rate
     *
     * @param string|null $video_frame_rate The video frame rate of the input file. Video with average frames per second (fps) less than 5 or greater than 120 is non-standard. A `-1` frame rate value indicates Mux could not determine the frame rate of the video track.
     *
     * @return self
     */
    public function setVideoFrameRate($video_frame_rate)
    {

        if (is_null($video_frame_rate)) {
            throw new \InvalidArgumentException('non-nullable video_frame_rate cannot be null');
        }

        $this->container['video_frame_rate'] = $video_frame_rate;

        return $this;
    }

    /**
     * Gets video_resolution
     *
     * @return string|null
     */
    public function getVideoResolution()
    {
        return $this->container['video_resolution'];
    }

    /**
     * Sets video_resolution
     *
     * @param string|null $video_resolution The video resolution of the input file. Video resolution higher than 2048 pixels on any one dimension (height or width) is considered non-standard, The resolution value is presented as `width` x `height` in pixels.
     *
     * @return self
     */
    public function setVideoResolution($video_resolution)
    {

        if (is_null($video_resolution)) {
            throw new \InvalidArgumentException('non-nullable video_resolution cannot be null');
        }

        $this->container['video_resolution'] = $video_resolution;

        return $this;
    }

    /**
     * Gets video_bitrate
     *
     * @return string|null
     */
    public function getVideoBitrate()
    {
        return $this->container['video_bitrate'];
    }

    /**
     * Sets video_bitrate
     *
     * @param string|null $video_bitrate The video bitrate of the input file is `high`. This parameter is present when the average bitrate of any key frame interval (also known as Group of Pictures or GOP) is higher than what's considered standard which typically is 16 Mbps.
     *
     * @return self
     */
    public function setVideoBitrate($video_bitrate)
    {
        $allowedValues = $this->getVideoBitrateAllowableValues();
        if (!is_null($video_bitrate) && !in_array($video_bitrate, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'video_bitrate', must be one of '%s'",
                    $video_bitrate,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($video_bitrate)) {
            throw new \InvalidArgumentException('non-nullable video_bitrate cannot be null');
        }

        $this->container['video_bitrate'] = $video_bitrate;

        return $this;
    }

    /**
     * Gets pixel_aspect_ratio
     *
     * @return string|null
     */
    public function getPixelAspectRatio()
    {
        return $this->container['pixel_aspect_ratio'];
    }

    /**
     * Sets pixel_aspect_ratio
     *
     * @param string|null $pixel_aspect_ratio The video pixel aspect ratio of the input file.
     *
     * @return self
     */
    public function setPixelAspectRatio($pixel_aspect_ratio)
    {

        if (is_null($pixel_aspect_ratio)) {
            throw new \InvalidArgumentException('non-nullable pixel_aspect_ratio cannot be null');
        }

        $this->container['pixel_aspect_ratio'] = $pixel_aspect_ratio;

        return $this;
    }

    /**
     * Gets video_edit_list
     *
     * @return string|null
     */
    public function getVideoEditList()
    {
        return $this->container['video_edit_list'];
    }

    /**
     * Sets video_edit_list
     *
     * @param string|null $video_edit_list Video Edit List reason indicates that the input file's video track contains a complex Edit Decision List.
     *
     * @return self
     */
    public function setVideoEditList($video_edit_list)
    {
        $allowedValues = $this->getVideoEditListAllowableValues();
        if (!is_null($video_edit_list) && !in_array($video_edit_list, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'video_edit_list', must be one of '%s'",
                    $video_edit_list,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($video_edit_list)) {
            throw new \InvalidArgumentException('non-nullable video_edit_list cannot be null');
        }

        $this->container['video_edit_list'] = $video_edit_list;

        return $this;
    }

    /**
     * Gets audio_edit_list
     *
     * @return string|null
     */
    public function getAudioEditList()
    {
        return $this->container['audio_edit_list'];
    }

    /**
     * Sets audio_edit_list
     *
     * @param string|null $audio_edit_list Audio Edit List reason indicates that the input file's audio track contains a complex Edit Decision List.
     *
     * @return self
     */
    public function setAudioEditList($audio_edit_list)
    {
        $allowedValues = $this->getAudioEditListAllowableValues();
        if (!is_null($audio_edit_list) && !in_array($audio_edit_list, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'audio_edit_list', must be one of '%s'",
                    $audio_edit_list,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($audio_edit_list)) {
            throw new \InvalidArgumentException('non-nullable audio_edit_list cannot be null');
        }

        $this->container['audio_edit_list'] = $audio_edit_list;

        return $this;
    }

    /**
     * Gets unexpected_media_file_parameters
     *
     * @return string|null
     */
    public function getUnexpectedMediaFileParameters()
    {
        return $this->container['unexpected_media_file_parameters'];
    }

    /**
     * Sets unexpected_media_file_parameters
     *
     * @param string|null $unexpected_media_file_parameters A catch-all reason when the input file in created with non-standard encoding parameters.
     *
     * @return self
     */
    public function setUnexpectedMediaFileParameters($unexpected_media_file_parameters)
    {
        $allowedValues = $this->getUnexpectedMediaFileParametersAllowableValues();
        if (!is_null($unexpected_media_file_parameters) && !in_array($unexpected_media_file_parameters, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'unexpected_media_file_parameters', must be one of '%s'",
                    $unexpected_media_file_parameters,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($unexpected_media_file_parameters)) {
            throw new \InvalidArgumentException('non-nullable unexpected_media_file_parameters cannot be null');
        }

        $this->container['unexpected_media_file_parameters'] = $unexpected_media_file_parameters;

        return $this;
    }

    /**
     * Gets unsupported_pixel_format
     *
     * @return string|null
     */
    public function getUnsupportedPixelFormat()
    {
        return $this->container['unsupported_pixel_format'];
    }

    /**
     * Sets unsupported_pixel_format
     *
     * @param string|null $unsupported_pixel_format The video pixel format, as a string, returned by libav. Considered non-standard if not one of yuv420p or yuvj420p.
     *
     * @return self
     */
    public function setUnsupportedPixelFormat($unsupported_pixel_format)
    {

        if (is_null($unsupported_pixel_format)) {
            throw new \InvalidArgumentException('non-nullable unsupported_pixel_format cannot be null');
        }

        $this->container['unsupported_pixel_format'] = $unsupported_pixel_format;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


