<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1TensorboardBlobSequence extends \Google\Collection
{
  protected $collection_key = 'values';
  /**
   * @var GoogleCloudAiplatformV1TensorboardBlob[]
   */
  public $values;
  protected $valuesType = GoogleCloudAiplatformV1TensorboardBlob::class;
  protected $valuesDataType = 'array';

  /**
   * @param GoogleCloudAiplatformV1TensorboardBlob[]
   */
  public function setValues($values)
  {
    $this->values = $values;
  }
  /**
   * @return GoogleCloudAiplatformV1TensorboardBlob[]
   */
  public function getValues()
  {
    return $this->values;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1TensorboardBlobSequence::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1TensorboardBlobSequence');
