<?php
/**
 * functions
 * 
 * @package Sngine
 * @author Zamblek
 */

/**
 * SystemError
 * 
 * @param string $title
 * @param string $message
 * @return void
 */
function SystemError($title, $message) {
    global $smarty;
    $smarty->assign('pageTitle', $title);
    $smarty->assign('errorTitle', $title);
    $smarty->assign('errorMessage', $message);
    $smarty->display('_systemerror.tpl');
    exit;
}

/**
 * SystemError
 * 
 * @param string $title
 * @param string $message
 * @return void
 */
function SQLError() {
    SystemError('Database Write Failed', 'An error occurred while writing to our database. Please try again later');
}

/**
 * PopupError
 * 
 * @param string $error
 * @param string $title
 * @return string
 */
function PopupError($error, $title = 'Error') {
    $data['status'] = 'error';
    $data['title'] = $title;
    $data['value'] = '<div class="pt5 pb5 pr5 pl5 fs12 white">'.$error.'</div>';
    return json_encode($data);
}

/**
 * ReportError
 * 
 * @param string $error
 * @return string
 */
function ReportError($error) {
    return '<div class="mr5 ml5"><div class="errorContianer stopCronJobs">An error occurred. <span class="uiButtonText reportError" id="'.$error.'">Report Error</span></div></div>';
}

/**
 * VerifyError
 * 
 * @return string
 */
function VerifyError() {
    global $userArray;
    exit(PopupError('<p class="fs11 mb10 tjustify">Before you can interact with other users, you need to confirm your email address. A confirmation email has been sent to <span class="blue fwb">'.$userArray['UserEmail'].'</span>. Check your email to complete your account confirmation.</p><p><small>Don\'t see the confirmation email? <span class="uiButtonText blue resendEmail">Resend to '.$userArray['UserEmail'].'</span></small><br/><small>Don\'t have access to '.$userArray['UserEmail'].'? <span class="uiButtonText blue changeEmail">Change your contact email.</span></small></p>', 'Confirm Your Email Address'));
}

/**
 * AccessLevel
 * 
 * @param string $level
 * @return void
 */
function AccessLevel($level = 'open') {
    global $translate, $userExist, $userArray;
    // check access level
    if($level == 'restricted') {
        // restricted access level
        if(!$userExist) {
            GetLogin($translate->__("You must sign in to see this page"));
        }elseif($userArray['GettingStarted'] == "N") {
            header('Location: '.SITE_URL.'/gettingstarted/step=1');
        }elseif($userArray['Blocked'] == "Y") {
            SystemError($translate->__("System Message"), $translate->__("Your account has been blocked."));
        }
    }else {
        // open access level
        if($userExist) {
            if($userArray['GettingStarted'] == "N") {
                header('Location: '.SITE_URL.'/gettingstarted/step=1');
            }elseif($userArray['Blocked'] == "Y") {
                SystemError($translate->__("System Message"), $translate->__("Your account has been blocked."));
            }
        }
    }
}

/**
 * GetLogin
 * 
 * @param string $message
 * @return void
 */
function GetLogin($message) {
    global $translate, $smarty;
    $smarty->assign('pageTitle', $translate->__("Sign in"));
    $smarty->assign('highlight', $message);
    $smarty->assign('page', 'signin');
    $smarty->display('signin.tpl');
    exit;
}

/**
 * PageHeader
 * 
 * @param string $title
 * @param string $description
 * @return void
 */
function PageHeader($title, $description = '') {
    global $translate, $smarty;
    $smarty->assign('pageTitle', $title);
    $description = ($description != '') ? $description : $translate->__(SITE_DESCRIPTION);
    $smarty->assign('pageDescription', $description);
}

/**
 * PageFooter
 * 
 * @param string $title
 * @param string $message
 * @return void
 */
function PageFooter($page) {
    global $smarty;
    $smarty->assign('page', $page);
    $smarty->display("$page.tpl");
}

/**
 * GetURLText
 * 
 * @param string $string
 * @param integer $length
 * @return string
 */
function GetURLText($string, $length = 10) {
    $string = htmlspecialchars_decode($string, ENT_QUOTES);
    $string = preg_replace('/[^\\pL\d]+/u', '-', $string);
    $string = trim($string, '-');
    $words = explode("-",$string);
    if(count($words) > $length) {
        $string = "";
        for($i = 0; $i < $length; $i++) {
            $string .= "-".$words[$i];
        }
        $string = trim($string, '-');
    }
    return $string;
}

/**
 * TextCut
 * 
 * @param string $text
 * @param integer $length
 * @return string
 */
function TextCut($text, $length = 20) {
    if(strlen($text) > $length){
        $string = explode(" ",$text);
        for($i = 0; $i < $length; $i++){
            $finalString .= " "."$string[$i]";
        }
        $finalString .= " "."...";
        return $finalString;
    }
    return $text;
}

/**
 * SeeMore
 * 
 * @param string $text
 * @param integer $length
 * @return string
 */
function SeeMore($text, $length = 5) {
    if(substr_count($text, '<br />') > $length) {
        $string = explode('<br />',$text);
        $finalString = '<span>';
        for($i = 0; $i < $length; $i++){
            $finalString .= $string[$i].'<br />';
        }
        $finalString .= '</span><span class="seeMore_button">...<br /><span>See More</span></span><span class="seeMore_text hidden">';
        for($j = $i+1; $j < count($string); $j++) {
            $finalString .= $string[$j].'<br />';
        }
        $finalString .= '</span>';
        return $finalString;
    }
    return $text;
}

/**
 * Parse
 * 
 * @param string $text
 * @return string
 */
function Parse($text) {
    $text = htmlspecialchars_decode($text);
    return $text;
}

/**
 * DecodeText
 * 
 * @param string $text
 * @param boolean $flag
 * @return string
 */
function DecodeText($text, $flag = true) {
    $text = preg_replace('/(https?:\/\/[^\s]+)/', "<a target='_blank' href=\"$1\">$1</a>", $text);
    $text = preg_replace('/([^a-zA-Z0-9-_&]+)#([0-9a-zA-Z_-]+)/', '$1<a href="'.SITE_URL.'/search.php?q=%23$2">#$2</a>', $text);
    $text = preg_replace_callback('/@\[(p|u)-([0-9]+)\]/', 'GetMention', $text);
    $text = DecodeEmoticons($text);
    if($flag) {
        $text = nl2br($text);
    }
    return $text;
}

/**
 * GetMention
 * 
 * @param array $matches
 * @return string
 */
function GetMention($matches) {
    global $db;
    if($matches[1] == 'p') {
        $getPage = $db->query(sprintf("SELECT * FROM pages WHERE ID = %s", Secure($matches[2], 'int'))) or SQLError();
        if($getPage->num_rows > 0) {
            $page = $getPage->fetch_array(MYSQLI_ASSOC);
            $page['URL'] = GetURLText($page['NameEn'].' - '.$page['NameAr']);
            $replacement = '<a href="'.SITE_URL.'/pages/'.$matches[2].'/'.$page['URL'].'">@'.$page['URL'].'</a>';
        }else {
            $replacement = $matches[0];
        }
        return $replacement;
    }elseif ($matches[1] == 'u') {
        $getUser = $db->query(sprintf("SELECT * FROM users WHERE UserID = %s", Secure($matches[2], 'int'))) or SQLError();
        if($getUser->num_rows > 0) {
            $user = $getUser->fetch_array(MYSQLI_ASSOC);
            $user['UserURL'] = SITE_URL."/".$user['UserName'];
            $replacement = '<a href="'.$user['UserURL'].'">@'.$user['UserFirstName'].' '.$user['UserLastName'].'</a>';
        }else {
            $replacement = $matches[0];
        }
        return $replacement;
        
    }
}

/**
 * PostMention
 * 
 * @param string $text
 * @param integer $activityId
 * @param integer $postId
 * @param integer $postType
 * @return string
 */
function PostMention($text, $activityId, $postId, $postType) {
    global $db, $now, $userArray;
    preg_match_all('/@\[(p|u)-([0-9]+)\]/', $text, $matches);
    for($i = 0; $i < count($matches[0]); $i++) {
        if($matches[1][$i] == 'p') {
            $isUser = 'N';
            $db->query(sprintf("INSERT INTO posts_mentions (PostID, MentionID, IsUser) VALUES (%s, %s, %s)", Secure($activityId, 'int'), Secure($matches[2][$i], 'int'), Secure($isUser) )) or SQLError();
        }elseif ($matches[1][$i] == 'u') {
            $isUser = 'Y';
            $db->query(sprintf("INSERT INTO posts_mentions (PostID, MentionID, IsUser) VALUES (%s, %s, %s)", Secure($activityId, 'int'), Secure($matches[2][$i], 'int'), Secure($isUser) )) or SQLError();
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Time) VALUES (%s, 9, %s, %s, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($matches[2][$i], 'int'), Secure($postType, 'int'), Secure($postId, 'int'), Secure($now) )) or SQLError();
            $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", Secure($matches[2][$i], 'int'))) or SQLError();
        }
    }
}

/**
 * DecodeEmoticons
 * 
 * @param string $text
 * @return string
 */
function DecodeEmoticons($text) {
    $src = SITE_URL.'/content/themes/default/images/misc/blank.gif';
    $emotions = array(
        'o.O'      => '<img class="emoticon" src="'.$src.'" style="background-position: -240px 0;" />',
        'O.o'      => '<img class="emoticon" src="'.$src.'" style="background-position: -240px 0;" />',
        '-_-'      => '<img class="emoticon" src="'.$src.'" style="background-position: -224px 0;" />',
        '^_^'      => '<img class="emoticon" src="'.$src.'" style="background-position: -208px 0;" />',
        '&lt;3'    => '<img class="emoticon" src="'.$src.'" style="background-position: -192px 0;" />',
        ':*'       => '<img class="emoticon" src="'.$src.'" style="background-position: -176px 0;" />',
        ':-*'      => '<img class="emoticon" src="'.$src.'" style="background-position: -176px 0;" />',
        '3:)'      => '<img class="emoticon" src="'.$src.'" style="background-position: -160px 0;" />',
        '3:-)'     => '<img class="emoticon" src="'.$src.'" style="background-position: -160px 0;" />',
        ':&#039;(' => '<img class="emoticon" src="'.$src.'" style="background-position: -144px 0;" />',
        ':-/'      => '<img class="emoticon" src="'.$src.'" style="background-position: -128px 0;" />',
        ':\\'      => '<img class="emoticon" src="'.$src.'" style="background-position: -128px 0;" />',
        ':-\\'     => '<img class="emoticon" src="'.$src.'" style="background-position: -128px 0;" />',
        '>:('      => '<img class="emoticon" src="'.$src.'" style="background-position: -112px 0;" />',
        '8)'       => '<img class="emoticon" src="'.$src.'" style="background-position: -96px 0;" />',
        '8-)'      => '<img class="emoticon" src="'.$src.'" style="background-position: -96px 0;" />',
        'B-)'      => '<img class="emoticon" src="'.$src.'" style="background-position: -96px 0;" />',
        'B)'       => '<img class="emoticon" src="'.$src.'" style="background-position: -96px 0;" />',
        ';)'       => '<img class="emoticon" src="'.$src.'" style="background-position: -80px 0;" />',
        ';-)'      => '<img class="emoticon" src="'.$src.'" style="background-position: -80px 0;" />',
        ':O'       => '<img class="emoticon" src="'.$src.'" style="background-position: -64px 0;" />',
        ':-O'      => '<img class="emoticon" src="'.$src.'" style="background-position: -64px 0;" />',
        ':-o'      => '<img class="emoticon" src="'.$src.'" style="background-position: -64px 0;" />',
        ':o'       => '<img class="emoticon" src="'.$src.'" style="background-position: -64px 0;" />',
        ':D'       => '<img class="emoticon" src="'.$src.'" style="background-position: -48px 0;" />',
        ':-D'      => '<img class="emoticon" src="'.$src.'" style="background-position: -48px 0;" />',
        '=D'       => '<img class="emoticon" src="'.$src.'" style="background-position: -48px 0;" />',
        ':P'       => '<img class="emoticon" src="'.$src.'" style="background-position: -32px 0;" />',
        ':-P'      => '<img class="emoticon" src="'.$src.'" style="background-position: -32px 0;" />',
        ':-p'      => '<img class="emoticon" src="'.$src.'" style="background-position: -32px 0;" />',
        ':p'       => '<img class="emoticon" src="'.$src.'" style="background-position: -32px 0;" />',
        '=P'       => '<img class="emoticon" src="'.$src.'" style="background-position: -32px 0;" />',
        ':('       => '<img class="emoticon" src="'.$src.'" style="background-position: -16px 0;" />',
        ':-('      => '<img class="emoticon" src="'.$src.'" style="background-position: -16px 0;" />',
        ':['       => '<img class="emoticon" src="'.$src.'" style="background-position: -16px 0;" />',
        '=('       => '<img class="emoticon" src="'.$src.'" style="background-position: -16px 0;" />',
        ':)'       => '<img class="emoticon" src="'.$src.'" style="background-position: 0 0;" />',
        ':-)'      => '<img class="emoticon" src="'.$src.'" style="background-position: 0 0;" />',
        ':]'       => '<img class="emoticon" src="'.$src.'" style="background-position: 0 0;" />',
        '=)'       => '<img class="emoticon" src="'.$src.'" style="background-position: 0 0;" />'
    );
    foreach($emotions as $pattern => $replacement) {
        $text = str_replace($pattern, $replacement, $text);
    }
    return $text;
}

/**
 * GetNotification
 * 
 * @param integer $type
 * @param integer $id
 * @param string $isMedia
 * @param string $isAlbum
 * @return string
 */
function GetNotification($type, $id, $isMedia = 'N', $isAlbum = 'N') {
    global $db;
    switch($type) {
        case 1:
            $notification['link'] = SITE_URL.'/newsfeed/'.$id;
            $notification['app'] = 'News';
            break;
        case 2:
            $notification['link'] = SITE_URL.'/track/'.$id.'/';
            $notification['app'] = 'Music';
            break;
        case 3:
            if($isMedia == "Y") {
                if($isAlbum == "Y") {
                    $notification['link'] = SITE_URL.'/albums/photos/'.$id.'/';
                    $notification['app'] = 'Photo Album';
                }else {
                    $notification['link'] = SITE_URL.'/photo/'.$id.'/';
                    $notification['app'] = 'Photo';
                }
            }else {
                $getPost = $db->query(sprintf("SELECT * FROM posts_photos WHERE ID = %s", SafeSQL($id, 'int')));
                $post = $getPost->fetch_array(MYSQLI_ASSOC);
                if($post['IsAlbum'] == "Y") {
                    $notification['link'] = SITE_URL.'/albums/photos/'.$post['MediaID'].'/';
                    $notification['app'] = 'Photo Album';
                }else {
                    $notification['link'] = SITE_URL.'/photo/'.$post['MediaID'].'/';
                    $notification['app'] = 'Photo';
                }
            }
            break;
        case 4:
            if($isMedia == "Y") {
                if($isAlbum == "Y") {
                    $notification['link'] = SITE_URL.'/albums/videos/'.$id.'/';
                    $notification['app'] = 'Video Album';
                }else {
                    $notification['link'] = 'video.php?id='.$id;
                    $notification['link'] = SITE_URL.'/video/'.$id.'/';
                    $notification['app'] = 'Video';
                }
            }else {
                $getPost = $db->query(sprintf("SELECT * FROM posts_videos WHERE ID = %s", SafeSQL($id, 'int')));
                $post = $getPost->fetch_array(MYSQLI_ASSOC);
                if($post['IsAlbum'] == "Y") {
                    $notification['link'] = SITE_URL.'/albums/videos/'.$post['MediaID'].'/';
                    $notification['app'] = 'Video Album';
                }else {
                    $notification['link'] = SITE_URL.'/video/'.$post['MediaID'].'/';
                    $notification['app'] = 'Video';
                }
            }
            break;
        case 5:
            $notification['link'] = SITE_URL.'/discussion/'.$id.'/';
            $notification['app'] = 'Discussion';
            break;
        case 6:
            $notification['link'] = SITE_URL.'/question/'.$id.'/';
            $notification['app'] = 'Question';
            break;
        case 7:
            $notification['link'] = SITE_URL.'/poll/'.$id.'/';
            $notification['app'] = 'Poll';
            break;
        case 8:
            $notification['link'] = SITE_URL.'/link/'.$id.'/';
            $notification['app'] = 'Link';
            break;
    }
    return $notification;
}

/**
 * GetMediaTable
 * 
 * @param integer $postType
 * @param integer $isAlbum
 * @return string
 */
function GetMediaTable($postType, $isAlbum) {
    if($postType == 3) {
        $app = 'photos';
    }elseif ($postType == 4) {
        $app = 'videos';
    }else {
        return false;
    }
    if($isAlbum == 1) {
        $type = 'albums';
    }elseif ($isAlbum == 0) {
        $type = 'sources';
    }else {
        return false;
    }
    return 'posts_'.$app.'_'.$type;
}

/**
 * GetArrayKey
 * 
 * @param array $array
 * @param integer $current
 * @param integer $offset
 * @return mixed
 */
function GetArrayKey($array, $current, $offset = 1) {
    $keys = array_keys($array);
    $index = array_search($current, $keys);
    if(isset($keys[$index + $offset])) {
        return $keys[$index + $offset];
    }
    return false;
}

/**
 * SendMail
 * 
 * @param string $email
 * @param string $subject
 * @param string $body
 * @return boolean
 */
function SendMail($email, $subject, $body) {
    $header  = "From: \"".SITE_TITLE."\" <"."no-reply@".SITE_DOMAIN.">\r\n";
    $header .= "MIME-Version: 1.0\r\n";
    $header .= "Mailer: ".SITE_TITLE."\r\n";
    $header .= "Content-Type: text/plain; charset=\"utf-8\"\r\n";
    $header .= "Content-Transfer-Encoding: 7bit\r\n";
    if(mail($email, $subject, $body, $header)) {
        return true;
    }else {
        return false;
    }
}

?>