<?php
/**
 * system functions
 * 
 * @package Sngine
 * @author Zamblek
 */

/**
 * Check for the required PHP version, and the MySQL extension.
 *
 * Dies if requirements are not met.
 *
 */
function _check_php_mysql_versions() {
    global $required_php_version, $sngine_version;
	$php_version = phpversion();
    if(version_compare( $required_php_version, $php_version, '>')) {
        die(sprintf('Your server is running PHP version %1$s but Sngine %2$s requires at least %3$s.', $php_version, $sngine_version, $required_php_version));
	}
    if(!extension_loaded('mysql')) {
        die('Your PHP installation appears to be missing the MySQL extension which is required by Sngine.');
    }
}

/**
 * _error
 * 
 * @param string $title
 * @param string $message
 * @return void
 */
function _error($title = 'System Error', $message = 'There is some thing went wrong') {
    echo '<!DOCTYPE html>
            <html>
            <head>
                <title>'.$title.'</title>
                <style type="text/css">
                    body,h1,h2,h3,ul,p,small{margin:0;padding:0}
                    body{color:#000;background:#ddd;direction:ltr;font-family: sans-serif;font-size:14px;line-height:1.5em;margin: 150px auto 0;width:650px;}
                    h1,h2,h3{font-weight:400}
                    h1{font: 24px Georgia, "Times New Roman", Times, serif;}
                    .roundBox{background: #fff; border: 1px solid #ccc; padding: 2em; color: #5D5D5D; -webkit-border-radius: 3px; border-radius: 3px;}
                    a {color: #21759b;text-decoration: none;}
                    a:hover {color: #d54e21;}
                    .roundBox h1{color: #666;font-weight:normal;font-size:22px;margin:0;}
                    .roundBox .msg{border-top:1px dotted #B8B8B8;margin-top:10px;padding-top:10px;}
                </style>
            </head>
            <body>
                <div class="roundBox">
                    <h1>'.$title.'</h1>
                    <div class="msg">'.$message.'</div>
                </div>
            </body>
            </html>';
    exit;
}

/**
 * _public_base_directory
 * 
 * gets the top level public directory
 * 
 * @return string
 */
function _public_base_directory() {
    //get public directory structure eg "/top/second/third"
    $public_directory = dirname($_SERVER['PHP_SELF']);
    //place each directory into array
    $directory_array = explode('/', $public_directory);
    //get highest or top level in array of directory strings
    $public_base = max($directory_array);
    return $public_base;
}

?>