<?php
/**
 * security functions
 * 
 * @package Sngine
 * @author Zamblek
 */

/**
 * IsAJAX
 * 
 * @return boolean
 */
function IsAJAX() {
    return (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'));
}

/**
 * IsEmpty
 * 
 * @param mixed $value
 * @return boolean
 */
function IsEmpty($value) {
    if(strlen(trim(preg_replace('/\xc2\xa0/',' ',$value))) == 0) {
        return true;
    }else {
        return false;
    }
}

/**
 * Secure
 * 
 * @param mixed $value
 * @param string $type
 * @return boolean
 */
function Secure($value, $type = "") {
    $value = Sanitize($value);
    $value = SafeSQL($value, $type);
    return $value;
}

/**
 * Sanitize
 * 
 * @param mixed $value
 * @return string
 */
function Sanitize($value) {
    if(get_magic_quotes_gpc()) $value = stripslashes($value);
    return htmlentities($value, ENT_QUOTES, 'utf-8');
}

/**
 * SafeSQL
 * 
 * @param mixed $value
 * @param string $type
 * @return string
 */
function SafeSQL($value, $type = "") {
    global $db;
    $value = $db->real_escape_string($value);
    if($type == 'int') {
        $value = "'" . intval($value) . "'";
    }elseif ($type == 'search') {
        $value = (!empty($value)) ? "'%" . $value . "%'" : "''";
    }else {
        $value = (!empty($value)) ? "'" . $value . "'" : "''";
    }
    return $value;
}

/**
 * ParseId
 * 
 * @param integer $id
 * @param integer $segment
 * @return mixed
 */
function ParseId($id, $segment = 2) {
    $pattern = '/^([0-9]+)-';
    for($i = 2; $i < $segment; $i++) {
        $pattern .= '([0-9]+)-';
    }
    $pattern .= '([0-9]+)$/';
    if(!preg_match($pattern, $id, $match)) {
        return false;
    }else {
        return $match;
    }
}

/**
 * ValidEmail
 * 
 * @param string $email
 * @return boolean
 */
function ValidEmail($email) {
    if(preg_match("/^[0-9a-z]+(([\.\-_])[0-9a-z]+)*@[0-9a-z]+(([\.\-])[0-9a-z-]+)*\.[a-z]{2,4}$/i", $email)) {
        return true;
    }else {
        return false;
    }
}

/**
 * ValidURL
 * 
 * @param string $email
 * @return boolean
 */
function ValidURL($url) {
    if(preg_match('/^https?:\/\/[^\s]+/i', $url)) {
        return true;
    }else {
        return false;
    }
}

/**
 * ValidString
 * 
 * @param string $string
 * @return boolean
 */
function ValidString($string) {
    if(preg_match('/^[a-z]*$/i', $string)) {
        return true;
    }else {
        return false;
    }
}

/**
 * ValidUserName
 * 
 * @param string $string
 * @return boolean
 */
function ValidUserName($string) {
    if(preg_match('/^[a-z0-9]*$/i', $string)) {
        return true;
    }else {
        return false;
    }
}

/**
 * ValidImg
 * 
 * @param string $file
 * @return boolean
 */
function ValidImg($file) {
    $extensions = array('jpg','gif','png');
    $len  = strLen($file)-3;
    $ext  = strtolower(substr($file, $len, 3));
    if(in_array($ext, $extensions)) {
        return true;
    }else {
        return false;
    }
}

?>