<?php
/**
 * translator class
 * 
 * @package Sngine
 * @author Zamblek
 */

class Translator {
    
    public $lang = array();
    private $_cookieLang = "s_lang";
    private $language = 'en';
    public $s_language = array('Title'=>'English', 'Translation'=>'English', 'Code'=>'en', 'Dir'=>'LTR'); // default language
    
    /**
     * Constructor
     *  
     */
    public function __construct() {
        global $db;
        if(isset($_COOKIE[$this->_cookieLang])) {
            $check = $db->query(sprintf("SELECT * FROM system_languages WHERE Code = %s", Secure($_COOKIE[$this->_cookieLang]))) or _error();
            if($check->num_rows > 0) {
                $this->language = $_COOKIE[$this->_cookieLang];
                $this->s_language = $check->fetch_array(MYSQLI_ASSOC);
            }
        }
    }
    
    /**
     * changeLanguage
     * 
     * @param string $lang
     * @return void
     */
    public function changeLanguage($lang) {
        global $db;
        $check = $db->query(sprintf("SELECT * FROM system_languages WHERE Code = %s", Secure($lang))) or _error();
        if($check->num_rows > 0) {
            $expire = time()+2592000;
            setcookie($this->_cookieLang, $lang, $expire, '/');
        }
    }
    
    /**
     * findString
     * 
     * @param string $str
     * @return string
     */
    private function findString($str) {
        if(array_key_exists($str, $this->lang[$this->language])) {
            return $this->lang[$this->language][$str];
        }
        return $str;
    }
    
    /**
     * splitStrings
     * 
     * @param string $str
     * @return array
     */
    private function splitStrings($str) {
        return explode('=',trim($str));
    }
    
    /**
     * __translator()
     * 
     * @param string $str
     * @return string
     */
    public function __($str) {
        if(!array_key_exists($this->language, $this->lang)) {
            $file = ABSPATH.'libs/languages/'.$this->language.'.txt';
            if(file_exists($file)) {
                $strings = array_map(array($this,'splitStrings'),file($file));
                foreach ($strings as $k => $v) {
					$this->lang[$this->language][$v[0]] = $v[1];
                }
                return $this->findString($str);
            }else {
                return $str;
            }
        }else {
            return $this->findString($str);
        }
        
    }
    
}
?>