<?php
/**
 * scraper class
 * 
 * @package Sngine
 * @author Zamblek
 */

class Scraper {
    
    public static function get($url) {
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; rv:1.7.3) Gecko/20041001 Firefox/0.10.1");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
        $contents = curl_exec($ch);
        if(!$contents) {
            throw new Exception("Please enter a valid link.");
        }
        curl_close($ch);
        return self::fixEncoding($contents);
    }
    
    public static function Sanitize($url) {
        
        $url = trim($url);
        if(!preg_match("/(?:f|ht)tps?/i", parse_url($url, PHP_URL_SCHEME))) {
            $url = "http://" . $url;
        }
        return $url;
    }
    
    public static function fixEncoding($html) {
        
        if(preg_match('/<meta.*charset="?([^"\'\/\>]+)"?/im', $html, $match)) {
            $encoding = strtolower($match[1]);
        }
        if(!preg_match('/utf-8/i', $encoding)) {
            $html = iconv($encoding, 'utf-8', $html);
        }
        $fixedHtml = mb_convert_encoding($html, 'HTML-ENTITIES', "UTF-8");
        return $fixedHtml;
    }
    
    public static function IsVideo($url) {
        
        $parsedURL = parse_url($url);
        
        // youtube video
        if(strpos($parsedURL['host'], "youtu.be") !== false || strpos($parsedURL['host'], 'youtube.com') !== false) {
            
            // get video id
            if(preg_match("/v=([\w\-]+)/i", $parsedURL['query'], $matches)) {
                $vedioId = $matches[1];
            }else {
                if(isset($parsedURL['path']) && strlen($parsedURL['path']) > 1) {
                    $vedioId = substr($parsedURL['path'], 1);
                }else {
                    return false;
                }
            }
            
            // type
            $type = 'youtube';
            
            // check videoId
            $headers = get_headers('http://gdata.youtube.com/feeds/api/videos/' . $vedioId);
            if(!strpos($headers[0], '200')) {
                throw new Exception("Please enter a valid  video link.");
            }
            
            // thumbnail
            $thumbnail = "http://img.youtube.com/vi/".$vedioId."/0.jpg";
            
        // vimeo video
        }elseif (strpos($parsedURL['host'], 'vimeo.com') !== false) {
            
            // get video id
            if(isset($parsedURL['path']) && strlen($parsedURL['path']) > 1) { 
                $vedioId = substr($parsedURL['path'], 1);
            }else {
                return false;
            }
            
            // type
            $type = 'vimeo';
            
            // check videoId
            $contents = unserialize(@file_get_contents('http://vimeo.com/api/v2/video/'.$vedioId.'.php'));
            if(!isset($contents[0]['thumbnail_large'])) {
                throw new Exception("Please enter a valid  video link.");
            }
            
            // thumbnail
            $thumbnail = $contents[0]['thumbnail_medium'];
            
        }else {
            return false;
        }
        
        $video = array('ID' => $vedioId, 'Type' => $type, 'Thumbnail' => $thumbnail);
        return $video;
    }
    
    public static function IsMusic($url) {
        
        $parsedURL = parse_url($url);
        
        if(strpos($parsedURL['host'], 'soundcloud.com') !== false) {
            
            // check track
            $contents = json_decode(@file_get_contents('http://soundcloud.com/oembed?format=json&url='.$url));
            if(!$contents) {
                throw new Exception("Please enter a valid  track link.");
            }
            
            // get track id
            preg_match_all('/[0-9]{8,15}/', $contents->html, $id);
            $trackId = $id[0][0];
            
        }else {
            return false;
        }
        
        $track = array('ID' => $trackId, 'Title' => $contents->title, 'Description' => $contents->description);
        return $track;
    }
    
}
?>