<?php
/**
 * pagination class
 * 
 * @package Sngine
 * @author Zamblek
 */

class Pagination {
    
    private $_page;
    private $_size;
    private $_total;
    private $_link;
    
    /**
     * Class Constructor
     * 
     * @param integer $page
     * @param integer $size
     * @param integer $total
     * @param string $link
     */
    public function __construct($page = null, $size = null, $total = null, $link = null) {
        
        $this->_page = $page;
		$this->_size = $size;
		$this->_total = $total;
        $this->_link = $link;
	}
    
    /**
     * getLimitSql
     * 
     * @return string
     */
    public function getLimitSql() {
        
        $sql = "LIMIT " . $this->getLimit();
        return $sql;
    }
    
    /**
     * getLimit
     * 
     * @return string
     */
    private function getLimit() {
        
        if($this->_total == 0) {
            $lastpage = 0;
        }else {
            $lastpage = ceil($this->_total/$this->_size);
        }
        
        $page = $this->_page;
        
        if($this->_page < 1) {
            $page = 1;
        }elseif ($this->_page > $lastpage && $lastpage > 0) {
            $page = $this->_page;
        }else {
            $page = $this->_page;
        }
        
        $sql = ($page - 1) * $this->_size . "," . $this->_size;
        
        return $sql;
    }
    
    /**
     * getPagerMini
     * 
     * @return string
     */
    public function getPagerMini() {
        
        global $translate;
        
        $totalPages = floor($this->_total / $this->_size);
        $totalPages += ($this->_total % $this->_size != 0) ? 1 : 0;
        
        if($totalPages <= 1) {
            return null;
		}
        
        if($this->_page > 1) {
            $prev = sprintf('<span class="uiButtonText pagerButton" id="%s">'.$translate->__('Prev').'</span>', $this->_page - 1);
        }else {
            $prev = 'Prev';
        }
        
        if($this->_page < $totalPages) {
            $next = sprintf('<span class="uiButtonText pagerButton" id="%s">'.$translate->__('Next').'</span>', $this->_page + 1);
        }else {
            $next = 'Next';
        }
        
        $output = '<span class="gray mr10">'.$translate->__('Page').' <span id="currentPage">'.$this->_page.'</span> '.$translate->__('of').' '.$totalPages.'</span> '.$prev.' · '.$next;
        
        return $output;
    }
    
    /**
     * getPagerAdmin
     * 
     * @return string
     */
    public function getPagerAdmin() {
        
        global $translate;
        
        $totalPages = floor($this->_total / $this->_size);
        $totalPages += ($this->_total % $this->_size != 0) ? 1 : 0;
        
        
        if($this->_page == $totalPages) {
            $to = ($this->_total - $this->_size) + $this->_size;
            $from = ($this->_page * $this->_size) - $this->_size  + 1;
        }else {
            $to = ($this->_page * $this->_size);
            $from = $to - $this->_size  + 1;
        }
        
        if($totalPages <= 1) {
            return null;
		}
        
        // total pages
        $output = '<li class="disabled"><a>'.$translate->__('Displaying').' '.$from.'-'.$to.' '.$translate->__("of").' '.$this->_total.'</a></li>';
        
        // prepare loop
        $loopStart = 1;
        $loopEnd = $totalPages;
        
        if($totalPages > 5) {
            if ($this->_page <= 3) {
                $loopStart = 1;
                $loopEnd = 5;
            }elseif ($this->_page >= $totalPages - 2) {
                $loopStart = $totalPages - 4;
                $loopEnd = $totalPages;
            }else {
                $loopStart = $this->_page - 2;
                $loopEnd = $this->_page + 2;
            }
        }
        
        // go to first page
        if($loopStart != 1) {
            $output .= sprintf('<li class="disabled"><a href="' . $this->_link . '">&#171;</a></li>', '1');
        }
        
        // previous page
        if($this->_page > 1) {
            $output .= sprintf('<li><a href="' . $this->_link . '">'.$translate->__('Prev').'</a></li>', $this->_page - 1);
        }
        
        // pages
        for($i = $loopStart; $i <= $loopEnd; $i++) {
            if($i == $this->_page) {
                $output .= '<li class="active"><a>' . $i . '</a></li> ';
            }else {
                $output .= sprintf('<li><a href="' . $this->_link . '">', $i) . $i . '</a></li> ';
            }
        }
        
        // next page
        if($this->_page < $totalPages) {
            $output .= sprintf('<li><a href="' . $this->_link . '">'.$translate->__('Next').'</a></li>', $this->_page + 1);
		}
        
        // go to last page
        if($loopEnd != $totalPages){
            $output .= sprintf('<li><a href="' . $this->_link . '">&#187;</a></li>', $totalPages);
		}
        
        return '<div class="pagination"><ul>' . $output . '</ul></div>';
    }
    
    /**
     * getPagerFull
     * 
     * @return string
     */
    public function getPager() {
        
        global $translate;
        
        $totalPages = floor($this->_total / $this->_size);
        $totalPages += ($this->_total % $this->_size != 0) ? 1 : 0;
        
        
        if($this->_page == $totalPages) {
            $to = ($this->_total - $this->_size) + $this->_size;
            $from = ($this->_page * $this->_size) - $this->_size  + 1;
        }else {
            $to = ($this->_page * $this->_size);
            $from = $to - $this->_size  + 1;
        }
        
        if($totalPages <= 1) {
            return null;
		}
        
        // total pages
        $output = '<span class="total">'.$translate->__('Displaying').' '.$from.'-'.$to.' '.$translate->__("of").' '.$this->_total.')</span>';
        
        // prepare loop
        $loopStart = 1;
        $loopEnd = $totalPages;
        
        if($totalPages > 5) {
            if ($this->_page <= 3) {
                $loopStart = 1;
                $loopEnd = 5;
            }elseif ($this->_page >= $totalPages - 2) {
                $loopStart = $totalPages - 4;
                $loopEnd = $totalPages;
            }else {
                $loopStart = $this->_page - 2;
                $loopEnd = $this->_page + 2;
            }
        }
        
        // go to first page
        if($loopStart != 1) {
            $output .= sprintf('<li class="disabledpage"><a href="' . $this->_link . '">&#171;</a></li>', '1');
        }
        
        // previous page
        if($this->_page > 1) {
            $output .= sprintf('<li class="nextpage"><a href="' . $this->_link . '">'.$translate->__('Prev').'</a></li>', $this->_page - 1);
        }
        
        // pages
        for($i = $loopStart; $i <= $loopEnd; $i++) {
            if($i == $this->_page) {
                $output .= '<li class="currentpage">' . $i . '</li> ';
            }else {
                $output .= sprintf('<li><a href="' . $this->_link . '">', $i) . $i . '</a></li> ';
            }
        }
        
        // next page
        if($this->_page < $totalPages) {
            $output .= sprintf('<li class="nextpage"><a href="' . $this->_link . '">'.$translate->__('Next').'</a></li>', $this->_page + 1);
		}
        
        // go to last page
        if($loopEnd != $totalPages){
            $output .= sprintf('<li class="nextpage"><a href="' . $this->_link . '">&#187;</a></li>', $totalPages);
		}
        
        return '<div class="pagination"><ul>' . $output . '</ul></div>';
    }
    
}
?>