/**
 * plugin textareaExpander
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

(function($) {

	$.fn.TextAreaExpander = function(minHeight, maxHeight) {
		
		// check if the browser  is Safari, IE, Chrome
		var hCheck = !($.browser.msie || $.browser.safari);

		// resize a textarea
		function ResizeTextarea(e) {

			// event or initialize element?
			e = e.target || e;

			// find content length and box width
			var vlen = e.value.length, ewidth = e.offsetWidth;
			if (vlen != e.valLength || ewidth != e.boxWidth) {

				if (vlen < e.valLength || ewidth != e.boxWidth) e.style.height = e.iniHeight+"px";
				var h = Math.max(e.expandMin, Math.min(e.scrollHeight, e.expandMax));
				
				var x = (!hCheck ? e.scrollHeight - e.padding: e.scrollHeight);
				e.style.overflow = (x > h ? "auto" : "hidden");
				e.style.height = x + "px";
				
				e.valLength = vlen;
				e.boxWidth = ewidth;
			}

			return true;
		};

		// initialize
		this.each(function() {

			// is a textarea?
			if (this.nodeName.toLowerCase() != "textarea") return;

			// set height restrictions
			var p = this.className.match(/expand(\d+)\-*(\d+)*/i);
			this.expandMin = minHeight || (p ? parseInt('0'+p[1], 10) : 0);
			this.expandMax = maxHeight || (p ? parseInt('0'+p[2], 10) : 99999);
			this.iniHeight = $(this).height();
			this.padding = parseInt($(this).css('padding-top')) + parseInt($(this).css('padding-bottom'));
			
			// initial resize
			ResizeTextarea(this);

			// zero vertical padding and add events
			if (!this.Initialized) {
				this.Initialized = true;
				$(this).bind("keyup", ResizeTextarea).bind("focus", ResizeTextarea);
			}
		});

		return this;
	};

})(jQuery);


// initialize all expanding textareas
jQuery(document).ready(function() {
	jQuery("textarea[class*=expand]").TextAreaExpander();
});